/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.accessibility;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.accessibility.ColorFilter;
import com.atlassian.bitbucket.dmz.accessibility.UserColorFilterSettingsService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.accessibility.RestColorFilter;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="/accessibility")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ColorFilterResource {
    private final I18nService i18nService;
    private final UserColorFilterSettingsService userColorFilterSettingsService;
    private final Validator validator;

    @Inject
    public ColorFilterResource(I18nService i18nService, UserColorFilterSettingsService userColorFilterSettingsService, Validator validator) {
        this.i18nService = i18nService;
        this.userColorFilterSettingsService = userColorFilterSettingsService;
        this.validator = validator;
    }

    @Operation(description="Retrieve the color filter for the current user.", summary="Get color filter")
    @ResponseDocs(value={@ResponseDoc(documentation="The color filter for the current user.", representation=RestColorFilter.class, responseCode=200), @ResponseDoc(documentation="The endpoint is being accessed anonymously when public access is disabled.", restError=true, responseCode=401), @ResponseDoc(documentation="The current user has not explicitly configured a color filter.", responseCode=404)})
    @GET
    @Path(value="color-filter")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getColorFilter() {
        return this.userColorFilterSettingsService.getColorFilter().map(filter -> ResponseFactory.ok((Object)((Object)new RestColorFilter((ColorFilter)filter))).build()).orElse(ResponseFactory.notFound().build());
    }

    @Operation(description="Update the color filter for the current user.", summary="Update color filter")
    @RequestBody(description="The color filter to set for the current user.", content={@Content(schema=@Schema(implementation=RestColorFilter.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated color filter for the current user.", representation=RestColorFilter.class, responseCode=200), @ResponseDoc(documentation="The endpoint is being accessed anonymously when public access is disabled.", restError=true, responseCode=401)})
    @PUT
    @Path(value="color-filter")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateColorFilter(RestColorFilter request) {
        ColorFilter colorFilter;
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        try {
            colorFilter = ColorFilter.fromValue((String)request.getColorFilter());
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)"colorFilter", (String)this.i18nService.getMessage("bitbucket.rest.accessibility.color-filter.invalid", new Object[]{request.getColorFilter(), ColorFilterResource.getColorFilterValues()})).build();
        }
        this.userColorFilterSettingsService.updateColorFilter(colorFilter);
        return this.getColorFilter();
    }

    private static List<String> getColorFilterValues() {
        return Arrays.stream(ColorFilter.values()).map(ColorFilter::getValue).toList();
    }
}

