/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.accessibility;

import com.atlassian.bitbucket.dmz.accessibility.ColorFilter;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;

public class RestColorFilter
extends RestMapEntity {
    private static final String COLOR_FILTER = "colorFilter";

    public RestColorFilter() {
    }

    public RestColorFilter(@Nonnull ColorFilter colorFilter) {
        this.put(COLOR_FILTER, Objects.requireNonNull(colorFilter, COLOR_FILTER).getValue());
    }

    @NotBlank(message="{bitbucket.rest.accessibility.color-filter.required}")
    @Schema(description="Color accessibility filter applied to the UI", example="red-green", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotBlank(message="{bitbucket.rest.accessibility.color-filter.required}") String getColorFilter() {
        return this.getStringProperty(COLOR_FILTER);
    }
}

