/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/merge-queue")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MergeQueueAdminResource {
    private final MergeQueueService mergeQueueService;

    @Inject
    public MergeQueueAdminResource(MergeQueueService mergeQueueService) {
        this.mergeQueueService = mergeQueueService;
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/check")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response triggerMergeQueueChecks(@BeanParam RepositoryResolver repositoryResolver) {
        this.mergeQueueService.triggerChecks(repositoryResolver.getRepository());
        return Response.noContent().build();
    }
}

