/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshController;
import com.atlassian.bitbucket.internal.rest.OptionalServiceRegistry;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.function.Function;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/config")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MeshConfigResource {
    private final OptionalServiceRegistry optionalServiceRegistry;

    @Inject
    public MeshConfigResource(OptionalServiceRegistry optionalServiceRegistry) {
        this.optionalServiceRegistry = optionalServiceRegistry;
    }

    @POST
    @Path(value="refresh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response refresh() {
        return this.ifAvailable(controller -> {
            controller.refreshConfiguration();
            return ResponseFactory.ok();
        });
    }

    private Response ifAvailable(Function<DmzMeshController, Response.ResponseBuilder> callback) {
        return this.optionalServiceRegistry.getMeshController().map(callback).orElse(ResponseFactory.notFound()).build();
    }
}

