/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshRemigrator;
import com.atlassian.bitbucket.dmz.migration.DmzMigrationService;
import com.atlassian.bitbucket.dmz.rest.v2.job.RestJob;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/remigration")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MeshRemigrationResource {
    private final DmzMigrationService migrationService;
    private final DmzMeshRemigrator remigrator;

    @Inject
    public MeshRemigrationResource(DmzMigrationService migrationService, DmzMeshRemigrator remigrator) {
        this.migrationService = migrationService;
        this.remigrator = remigrator;
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/abort")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response abort(@BeanParam RepositoryResolver repositoryResolver) {
        this.remigrator.abort(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/commit")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response commit(@BeanParam RepositoryResolver repositoryResolver) {
        this.remigrator.commit(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{jobId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMeshRemigrationJob(@PathParam(value="jobId") long jobId) {
        return this.migrationService.getMeshRemigrationJob(jobId).map(RestJob::new).map(ResponseFactory::ok).orElseGet(ResponseFactory::notFound).build();
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/prepare")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response prepare(@BeanParam RepositoryResolver repositoryResolver) {
        List repositories = this.remigrator.prepare(repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)ImmutableMap.of((Object)"hierarchyId", (Object)repositoryResolver.getRepository().getHierarchyId(), (Object)"ids", repositories.stream().map(Repository::getId).collect(Collectors.toList()))).build();
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response remigrate(@BeanParam RepositoryResolver repositoryResolver) {
        Job job = this.migrationService.startMeshRemigration(repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)new RestJob(job)).build();
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/partition/{partitionId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setPartitionId(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="partitionId") int partitionId) {
        this.remigrator.setPartition(repositoryResolver.getRepository(), partitionId);
        return ResponseFactory.ok().build();
    }
}

