/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionMigrationService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.InconsistentRepositoryReplica;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigration;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationSearchRequest;
import com.atlassian.bitbucket.dmz.mesh.MeshSettings;
import com.atlassian.bitbucket.dmz.mesh.MeshSettingsUpdateRequest;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshNode;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshPartitionMigration;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshPartitionMigrationRequest;
import com.atlassian.bitbucket.internal.rest.admin.RestMeshSettings;
import com.atlassian.bitbucket.internal.rest.admin.RestMeshSettingsUpdateRequest;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MeshResource {
    private final DmzMeshService meshService;
    private final DmzMeshPartitionMigrationService migrationService;
    private final RepositoryService repositoryService;

    @Inject
    public MeshResource(DmzMeshService meshService, DmzMeshPartitionMigrationService migrationService, RepositoryService repositoryService) {
        this.meshService = meshService;
        this.migrationService = migrationService;
        this.repositoryService = repositoryService;
    }

    @POST
    @Path(value="/partition-migration/{id}/cancel")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelPartitionMigration(@PathParam(value="id") long id) {
        this.migrationService.cancel(id);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/partition-migration")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createPartitionMigration(@Context UriInfo uriInfo, RestMeshPartitionMigrationRequest request) {
        MeshNode sourceNode = this.meshService.getMember(request.getSourceNodeId());
        MeshNode targetNode = this.meshService.getMember(request.getTargetNodeId());
        MeshPartitionMigrationRequest serviceRequest = new MeshPartitionMigrationRequest.Builder(request.getPartition(), sourceNode, targetNode).build();
        MeshPartitionMigration migration = this.migrationService.migrate(serviceRequest);
        return Response.created((URI)uriInfo.getRequestUriBuilder().path(String.valueOf(migration.getId())).build(new Object[0])).entity((Object)new RestMeshPartitionMigration(migration)).build();
    }

    @POST
    @Path(value="/ensure-partition-count")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response ensurePartitionCount() {
        this.meshService.ensurePartitionCount();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/inconsistent-replicas")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getInconsistentReplicas() {
        Map result = this.meshService.getInconsistentRepositoryReplicas();
        return ResponseFactory.ok().entity(this.buildInconsistentRepositoryReplicaReport(result)).build();
    }

    @GET
    @Path(value="/nodes/{id}/info")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getNodeInfo(@PathParam(value="id") long id) {
        return ResponseFactory.ok().entity((Object)this.meshService.getMemberInfo(id)).build();
    }

    @GET
    @Path(value="/partition-migration/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPartitionMigration(@PathParam(value="id") long id) {
        MeshPartitionMigration entity = this.migrationService.getById(id);
        if (entity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new RestMeshPartitionMigration(entity)).build();
    }

    @GET
    @Path(value="/settings")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSettings() {
        return ResponseFactory.ok((Object)((Object)new RestMeshSettings(this.meshService.getSettings()))).build();
    }

    @GET
    @Path(value="/partition-migration")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchPartitionMigrations(@QueryParam(value="partition") Integer partition, @QueryParam(value="state") List<MeshPartitionMigrationJobState> jobStates, @QueryParam(value="sourceNodeId") List<Long> sourceNodeIds, @QueryParam(value="targetNodeId") List<Long> targetNodeIds, @BeanParam PageRequestResolver pageRequestResolver) {
        MeshPartitionMigrationSearchRequest.Builder builder = new MeshPartitionMigrationSearchRequest.Builder().states(jobStates).sourceNodeIds(sourceNodeIds).targetNodeIds(targetNodeIds);
        if (partition != null) {
            builder.partition(partition);
        }
        Page search = this.migrationService.search(builder.build(), pageRequestResolver.getPageRequest());
        return Response.ok((Object)new RestPage(search.transform(RestMeshPartitionMigration::new))).build();
    }

    @PUT
    @Path(value="/settings")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateSettings(RestMeshSettingsUpdateRequest request) {
        MeshSettingsUpdateRequest.Builder builder = new MeshSettingsUpdateRequest.Builder();
        Boolean repositoryCreationEnabled = request.isRepositoryCreationEnabled();
        if (repositoryCreationEnabled != null) {
            builder.repositoryCreationEnabled(repositoryCreationEnabled.booleanValue());
            MeshSettings updated = this.meshService.updateSettings(builder.build());
            return ResponseFactory.ok((Object)((Object)new RestMeshSettings(updated))).build();
        }
        return ResponseFactory.badRequest().build();
    }

    private List<Map<String, Object>> buildInconsistentRepositoryReplicaReport(Map<MeshNode, Collection<InconsistentRepositoryReplica>> value) {
        ImmutableList.Builder builder = ImmutableList.builder();
        value.forEach((node, inconsistentReplicas) -> builder.add((Object)ImmutableMap.of((Object)"node", (Object)new RestMeshNode(node), (Object)"inconsistentReplicas", inconsistentReplicas.stream().map(ir -> ImmutableMap.of((Object)"repository", (Object)new RestRepository(this.getRepository(ir.getRepositoryId())), (Object)"remoteId", (Object)ir.getRepositoryId().toString(), (Object)"version", (Object)ir.getVersion())).collect(MoreCollectors.toImmutableList()))));
        return builder.build();
    }

    private Repository getRepository(RemoteRepositoryId remoteId) {
        return this.repositoryService.getById(remoteId.getLocalId());
    }
}

