/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.admin;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshTroubleshootingService;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.dmz.mesh.RepositoryReplicaDetails;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshNode;
import com.atlassian.bitbucket.internal.rest.OptionalServiceRegistry;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/troubleshooting/")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MeshTroubleshootingResource {
    private static final Logger log = LoggerFactory.getLogger(MeshTroubleshootingResource.class);
    private final OptionalServiceRegistry optionalServiceRegistry;

    @Inject
    public MeshTroubleshootingResource(OptionalServiceRegistry optionalServiceRegistry) {
        this.optionalServiceRegistry = optionalServiceRegistry;
    }

    @GET
    @Path(value="replicas")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getReplicas(@QueryParam(value="mismatchOnly") @DefaultValue(value="true") boolean mismatchOnly) {
        return this.ifAvailable(troubleshootingService -> this.internalGetReplicas((DmzMeshTroubleshootingService)troubleshootingService, mismatchOnly));
    }

    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/replicas")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getReplicas(@BeanParam RepositoryResolver repositoryResolver) {
        return this.ifAvailable(troubleshootingService -> MeshTroubleshootingResource.internalGetReplicas(troubleshootingService, repositoryResolver.getRepository()));
    }

    @POST
    @Path(value="/topology-publish")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response publishTopology() {
        return this.ifAvailable(troubleshootingService -> {
            troubleshootingService.forceTopologyUpdate();
            return ResponseFactory.ok();
        });
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/replicas/{nodeId}/repair")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response repairReplica(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="nodeId") long targetNodeId, @QueryParam(value="sourceNodeId") long sourceNodeId) {
        return this.ifAvailable(troubleshootingService -> {
            boolean success = troubleshootingService.repairReplica(repositoryResolver.getRepository(), sourceNodeId, targetNodeId);
            return ResponseFactory.ok((Object)ImmutableMap.of((Object)"success", (Object)success));
        });
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/repair")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response repairReplicaSet(@BeanParam RepositoryResolver repositoryResolver) {
        return this.ifAvailable(troubleshootingService -> {
            try {
                troubleshootingService.repair(repositoryResolver.getRepository());
            }
            catch (IllegalStateException e) {
                return ResponseFactory.conflict().entity((Object)new RestErrors.Builder().add(e.getMessage()).build());
            }
            return MeshTroubleshootingResource.internalGetReplicas(troubleshootingService, repositoryResolver.getRepository());
        });
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/replicas/{nodeId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setReplicaState(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="nodeId") long nodeId, @Valid RestReplicaStateRequest request) {
        return this.ifAvailable(troubleshootingService -> {
            troubleshootingService.setReplicaState(nodeId, repositoryResolver.getRepository(), request.getReplicaState(), request.getVersion(), request.isForce());
            return ResponseFactory.ok();
        });
    }

    @POST
    @Path(value="/verify-consistency")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response verifyConsistency() {
        return this.ifAvailable(troubleshootingService -> ResponseFactory.ok((Object)new JsonStreamingOutput(this, (DmzMeshTroubleshootingService)troubleshootingService){
            final /* synthetic */ DmzMeshTroubleshootingService val$troubleshootingService;
            {
                this.val$troubleshootingService = dmzMeshTroubleshootingService;
            }

            public void write(StatefulJsonWriter writer) throws WebApplicationException, IOException {
                writer.beginArray();
                this.val$troubleshootingService.verifyConsistency((repository, messages) -> {
                    try {
                        writer.beginObject().name("repository").value(repository.toString()).name("inconsistencies").beginArray();
                        messages.forEach(m -> {
                            try {
                                writer.value(m);
                            }
                            catch (IOException e) {
                                log.error("Error while writing inconsistency message to the JSON array", (Throwable)e);
                                throw new UncheckedIOException(e);
                            }
                        });
                        writer.endArray().endObject();
                    }
                    catch (IOException e) {
                        log.error("Error while writing JSON output for repository inconsistencies", (Throwable)e);
                        throw new UncheckedIOException(e);
                    }
                });
                writer.endArray();
            }
        }));
    }

    private static Response.ResponseBuilder getResponseBuilder(Map<MeshNode, RepositoryReplicaDetails> controlPlaneDetails, Map<MeshNode, RepositoryReplicaDetails> nodeDetails) {
        return ResponseFactory.ok().entity(Sets.union(controlPlaneDetails.keySet(), nodeDetails.keySet()).stream().map(node -> new RestNodeRepositoryReplicaDetails((MeshNode)node, (RepositoryReplicaDetails)controlPlaneDetails.get(node), (RepositoryReplicaDetails)nodeDetails.get(node))).collect(MoreCollectors.toImmutableList()));
    }

    private static Response.ResponseBuilder internalGetReplicas(DmzMeshTroubleshootingService troubleshootingService, Repository repository) {
        Map controlPlaneDetails = troubleshootingService.getReplicasDetailsFromControlPlane(repository);
        Map nodeDetails = troubleshootingService.getReplicasDetailsFromNodes(repository);
        return MeshTroubleshootingResource.getResponseBuilder(controlPlaneDetails, nodeDetails);
    }

    private Response ifAvailable(Function<DmzMeshTroubleshootingService, Response.ResponseBuilder> callback) {
        return this.optionalServiceRegistry.getMeshTroubleshootingService().map(callback).orElse(ResponseFactory.notFound()).build();
    }

    private Response.ResponseBuilder internalGetReplicas(final DmzMeshTroubleshootingService troubleshootingService, final boolean mismatchOnly) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(this){

            public void write(StatefulJsonWriter writer) throws WebApplicationException, IOException {
                writer.beginArray();
                troubleshootingService.streamRemoteRepositories(repository -> {
                    try {
                        boolean includeReplicateDetails;
                        Map controlPlaneDetails = troubleshootingService.getReplicasDetailsFromControlPlane(repository);
                        Map nodeDetails = troubleshootingService.getReplicasDetailsFromNodes(repository);
                        boolean bl = includeReplicateDetails = !mismatchOnly || !this.isMatchingReplicaState(controlPlaneDetails, nodeDetails);
                        if (includeReplicateDetails) {
                            writer.beginObject().name("repository").value(repository.toString()).name("replicas").value(MeshTroubleshootingResource.getResponseBuilder(controlPlaneDetails, nodeDetails).build().getEntity()).endObject();
                        }
                    }
                    catch (IOException e) {
                        log.error("Exception while writing JSON response for the repository: {}", (Object)repository, (Object)e);
                        return false;
                    }
                    catch (RuntimeException e) {
                        log.error("Exception while streaming replicas for the repository: {}", (Object)repository, (Object)e);
                    }
                    return true;
                });
                writer.endArray();
            }

            private boolean isMatchingReplicaState(Map<MeshNode, RepositoryReplicaDetails> controlPlaneDetails, Map<MeshNode, RepositoryReplicaDetails> nodeDetails) {
                return controlPlaneDetails.size() == nodeDetails.size() && controlPlaneDetails.keySet().stream().noneMatch(cpNode -> {
                    RepositoryReplicaDetails nodeReplicaDetails = (RepositoryReplicaDetails)nodeDetails.get(cpNode);
                    return nodeReplicaDetails == null || !((RepositoryReplicaDetails)controlPlaneDetails.get(cpNode)).getReplicaState().equals((Object)nodeReplicaDetails.getReplicaState());
                });
            }
        });
    }

    static class RestReplicaStateRequest {
        private boolean force;
        private ReplicaState replicaState;
        private long version;

        RestReplicaStateRequest() {
        }

        @NotNull
        public ReplicaState getReplicaState() {
            return this.replicaState;
        }

        @Min(value=2L)
        public @Min(value=2L) long getVersion() {
            return this.version;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean value) {
            this.force = value;
        }

        public void setReplicaState(ReplicaState value) {
            this.replicaState = value;
        }

        public void setVersion(long value) {
            this.version = value;
        }
    }

    static class RestNodeRepositoryReplicaDetails
    extends RestMapEntity {
        RestNodeRepositoryReplicaDetails(MeshNode node, RepositoryReplicaDetails controlPlaneDetails, RepositoryReplicaDetails nodeDetails) {
            this.put("node", new RestMeshNode(node));
            if (controlPlaneDetails != null) {
                this.put("controlPlaneState", (Object)new RestRepositoryReplicaDetails(controlPlaneDetails));
            }
            if (nodeDetails != null) {
                this.put("nodeState", (Object)new RestRepositoryReplicaDetails(nodeDetails));
            }
        }
    }

    static class RestRepositoryReplicaDetails
    extends RestMapEntity {
        RestRepositoryReplicaDetails(RepositoryReplicaDetails details) {
            this.putIfNotNull("contentHash", details.getContentHash());
            this.putIfNotNull("metadataHash", details.getMetadataHash());
            this.put("replicaState", details.getReplicaState());
            if (details.getObservedVersion() > 0L) {
                this.put("observedVersion", details.getObservedVersion());
            }
            if (details.getVersion() > 0L) {
                this.put("version", details.getVersion());
            }
        }
    }
}

