/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.auth.websudo;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.auth.websudo.BitbucketWebSudoManager;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Path(value="/websudo-session")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class WebSudoSessionResource {
    private final BitbucketWebSudoManager webSudoManager;

    @Inject
    public WebSudoSessionResource(BitbucketWebSudoManager webSudoManager) {
        this.webSudoManager = webSudoManager;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getExpiry(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        return this.webSudoManager.getWebSudoSessionExpiry(servletRequest).map(expiry -> Response.ok((Object)ImmutableMap.builder().put((Object)"expiry", (Object)expiry.toEpochMilli()).build()).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response refreshWebSudoSession(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        this.webSudoManager.willExecuteWebSudoRequest(servletRequest);
        return this.getExpiry(servletRequest, servletResponse);
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response removeWebSudoSession(@Context HttpServletRequest servletRequest) {
        this.webSudoManager.removeWebSudoSession(servletRequest);
        return Response.noContent().build();
    }
}

