/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.operations;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.build.server.operations.ActionResult;
import com.atlassian.bitbucket.dmz.build.BuildStatusOperationRequest;
import com.atlassian.bitbucket.dmz.build.BuildStatusOperationResponse;
import com.atlassian.bitbucket.dmz.build.operations.DmzBuildServerOperationsService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.build.operations.RestActionResult;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildAction;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildOperations;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildStatusOperationRequest;
import com.atlassian.bitbucket.internal.rest.build.operations.RestBuildStatusOperationResult;
import com.atlassian.bitbucket.internal.rest.build.server.RestBuildServer;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@LicensedOnly
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/build-operations")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildStatusOperationsResource {
    private static final String ACTION_TIMEOUT_SECONDS = "plugin.bitbucket-rest-ui.actions.timeout.seconds";
    private static final int DEFAULT_ACTION_TIMEOUT_SECONDS = 15;
    private final DmzBuildServerOperationsService buildOperationsService;
    private final I18nService i18nService;
    private final ApplicationPropertiesService propertiesService;
    private final Validator validator;

    @Inject
    public BuildStatusOperationsResource(DmzBuildServerOperationsService buildOperationsService, I18nService i18nService, ApplicationPropertiesService propertiesService, Validator validator) {
        this.i18nService = i18nService;
        this.buildOperationsService = buildOperationsService;
        this.propertiesService = propertiesService;
        this.validator = validator;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getOperations(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="key") String key) {
        return this.buildOperationsService.getOperations(repositoryResolver.getRepository(), commitId, key).map(RestBuildOperations::new).map(ResponseFactory::ok).orElseGet(ResponseFactory::notFound).build();
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response performAction(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, RestBuildStatusOperationRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        BuildStatusOperationResponse response = this.buildOperationsService.performOperation(new BuildStatusOperationRequest.Builder(request.getId(), request.getKey(), commitId, repositoryResolver.getRepository()).build());
        RestBuildServer restBuildServer = new RestBuildServer(response.getBuildServer());
        RestBuildAction restBuildAction = new RestBuildAction(response.getAction());
        RestActionResult restActionResult = this.getActionResult(response);
        return Response.ok((Object)((Object)new RestBuildStatusOperationResult(restBuildAction, restActionResult, restBuildServer))).build();
    }

    private RestActionResult getActionResult(BuildStatusOperationResponse response) {
        Future future = response.getResult();
        try {
            ActionResult result = (ActionResult)future.get(this.propertiesService.getPluginProperty(ACTION_TIMEOUT_SECONDS, 15), TimeUnit.SECONDS);
            return new RestActionResult(result);
        }
        catch (TimeoutException e) {
            return new RestActionResult(this.i18nService.getMessage("bitbucket.rest.build.action.request.timeout", new Object[]{response.getAction().getName(), response.getBuildServer().getName()}), "TIMEOUT", null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

