/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.operations;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RestBuildStatusOperationRequest
extends RestMapEntity {
    private static final String ACTION_ID = "id";
    private static final String BUILD_KEY = "key";

    public RestBuildStatusOperationRequest() {
    }

    public RestBuildStatusOperationRequest(@Nonnull String key, @Nonnull String actionId) {
        this.put(BUILD_KEY, Objects.requireNonNull(StringUtils.stripToNull((String)key), BUILD_KEY));
        this.put(ACTION_ID, Objects.requireNonNull(StringUtils.stripToNull((String)actionId), "actionId"));
    }

    @NotBlank(message="{bitbucket.rest.build.action.request.key.required}")
    @Nonnull
    public @NotBlank(message="{bitbucket.rest.build.action.request.key.required}") String getKey() {
        return this.getStringProperty(BUILD_KEY);
    }

    @NotBlank(message="{bitbucket.rest.build.action.request.id.required}")
    @Nonnull
    public @NotBlank(message="{bitbucket.rest.build.action.request.id.required}") String getId() {
        return this.getStringProperty(ACTION_ID);
    }
}

