/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.status;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.status.BuildStatusPullRequestSearchRequest;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.build.status.InternalRestBuildStatus;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusSearchResponse;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusTransformer;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/builds")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildStatusPullRequestSearchResource {
    private final DmzBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final RestBuildStatusTransformer restBuildStatusTransformer;

    @Inject
    public BuildStatusPullRequestSearchResource(RestBuildStatusTransformer restBuildStatusTransformer, DmzBuildStatusService buildStatusService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.buildStatusService = buildStatusService;
        this.restBuildStatusTransformer = restBuildStatusTransformer;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response search(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="orderBy") @DefaultValue(value="newest") String orderBy, @QueryParam(value="commitId") String commitId, @BeanParam PageRequestResolver pageRequestResolver, @Context ContainerRequestContext requestContext) {
        BuildOrder buildOrder = (BuildOrder)BuildOrder.fromString((String)orderBy).orElseThrow(() -> new BadRequestException(this.i18nService.getMessage("bitbucket.rest.build.status.order.invalid", new Object[]{orderBy, Arrays.asList(BuildOrder.values())})));
        Page page = this.buildStatusService.searchInternal(((BuildStatusPullRequestSearchRequest.Builder)((BuildStatusPullRequestSearchRequest.Builder)new BuildStatusPullRequestSearchRequest.Builder(pullRequestResolver.getPullRequest()).buildOrder(buildOrder)).commitId(commitId)).build(), pageRequestResolver.getPageRequest());
        RestPage<InternalRestBuildStatus> buildStatusPage = this.restBuildStatusTransformer.transform((Page<RepositoryBuildStatus>)page, requestContext);
        RestPullRequest restPullRequest = new RestPullRequest(pullRequestResolver.getPullRequest());
        return ResponseFactory.ok((Object)((Object)new RestBuildStatusSearchResponse(restPullRequest, buildStatusPage))).build();
    }
}

