/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.status;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestTestResults;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.build.server.RestBuildServer;
import com.atlassian.bitbucket.internal.rest.build.status.InternalRestBuildStatus;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusLinks;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class RestBuildStatusTransformer {
    private final AvatarEnricher avatarEnricher;
    private final I18nService i18nService;
    private final PermissionService permissionService;

    public RestBuildStatusTransformer(AvatarEnricher avatarEnricher, I18nService i18nService, PermissionService permissionService) {
        this.avatarEnricher = avatarEnricher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    public RestPage<InternalRestBuildStatus> transform(@Nonnull Page<RepositoryBuildStatus> page, @Nonnull ContainerRequestContext requestContext) {
        Function commitTransformer = RestCommit.createTransformer((ContainerRequestContext)requestContext, (AvatarEnricher)this.avatarEnricher, (I18nService)this.i18nService);
        HashMap restCommitCache = new HashMap();
        return new RestPage(page, buildStatus -> {
            RestCommit commit = RestBuildStatusTransformer.getRestCommit(commitTransformer, restCommitCache, buildStatus);
            Repository repository = buildStatus.getRepository();
            return new InternalRestBuildStatus(buildStatus.getBuildNumber().orElse(null), RestBuildStatusTransformer.getRestBuildServer(buildStatus), this.isActionsEnabled((RepositoryBuildStatus)buildStatus), commit, buildStatus.getCreatedDate(), buildStatus.getDescription().orElse(null), buildStatus.getDuration().orElse(null), buildStatus.getKey(), this.getRestLinks((RepositoryBuildStatus)buildStatus), buildStatus.getName().orElse(null), buildStatus.getParent().orElse(null), repository.getProject().getKey(), buildStatus.getRef().orElse(null), repository.getSlug(), buildStatus.getState(), RestBuildStatusTransformer.getRestTestResults(buildStatus), buildStatus.getUpdatedDate(), buildStatus.getUrl());
        });
    }

    private boolean isActionsEnabled(RepositoryBuildStatus buildStatus) {
        return buildStatus.getBuildServer().isPresent() && this.permissionService.hasRepositoryPermission(buildStatus.getRepository(), Permission.REPO_WRITE);
    }

    private static RestBuildServer getRestBuildServer(RepositoryBuildStatus buildStatus) {
        return buildStatus.getBuildServer().map(RestBuildServer::new).orElse(null);
    }

    private static RestCommit getRestCommit(Function<Commit, RestCommit> commitTransformer, Map<Commit, RestCommit> restCommitCache, RepositoryBuildStatus buildStatus) {
        return buildStatus.getCommit().map(commit -> (RestCommit)restCommitCache.computeIfAbsent((Commit)commit, commitTransformer)).orElse(null);
    }

    private static RestTestResults getRestTestResults(RepositoryBuildStatus buildStatus) {
        return buildStatus.getTestResults().map(RestTestResults::new).orElse(null);
    }

    private RestBuildStatusLinks getRestLinks(RepositoryBuildStatus buildStatus) {
        if (!buildStatus.getBuildStatusLinks().getLogsLink().isPresent() && !buildStatus.getBuildStatusLinks().getArtifactsLink().isPresent()) {
            return null;
        }
        return new RestBuildStatusLinks(buildStatus.getBuildStatusLinks());
    }
}

