/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.summary;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.PullRequestBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.internal.rest.build.summary.RestBuildSummaries;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/build-summaries")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildStatusPullRequestSummaryResource {
    private final DmzBuildStatusService buildStatusService;

    @Inject
    public BuildStatusPullRequestSummaryResource(DmzBuildStatusService buildStatusService) {
        this.buildStatusService = buildStatusService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response search(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="commitId") List<String> commitIds) {
        PullRequestBulkCommitBuildStatusSummaryRequest request = ((PullRequestBulkCommitBuildStatusSummaryRequest.Builder)new PullRequestBulkCommitBuildStatusSummaryRequest.Builder(pullRequestResolver.getPullRequest(), new String[0]).commitIds(commitIds)).build();
        Map summaries = this.buildStatusService.getSummaries(request);
        return ResponseFactory.ok((Object)((Object)new RestBuildSummaries(summaries))).build();
    }
}

