/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.build.summary;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.BulkPullRequestBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.BulkRefBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.RefBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.build.summary.RestBuildSummaries;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/build-summaries")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class BuildStatusRepositorySummaryResource {
    private final DmzBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final RefService refService;

    @Inject
    public BuildStatusRepositorySummaryResource(DmzBuildStatusService buildStatusService, I18nService i18nService, RefService refService) {
        this.i18nService = i18nService;
        this.buildStatusService = buildStatusService;
        this.refService = refService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSummaries(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="commitId") List<String> commitIds, @QueryParam(value="ref") List<String> refs, @QueryParam(value="pullRequestId") List<Long> prIds) {
        if (!(commitIds.isEmpty() || refs.size() <= 1 && prIds.size() <= 1)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.build.status.bulk.refs.and.commits", new Object[0]));
        }
        if (!refs.isEmpty() && !prIds.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.build.status.bulk.prs.and.refs", new Object[0]));
        }
        Map<String, BuildSummary> summaries = this.getSummaries(repositoryResolver.getRepository(), commitIds, refs, prIds);
        return ResponseFactory.ok((Object)((Object)new RestBuildSummaries(summaries))).build();
    }

    private Map<String, BuildSummary> getBulkCommitSummaries(Repository repository, List<String> commitIds, String ref) {
        RefBulkCommitBuildStatusSummaryRequest.Builder requestBuilder = (RefBulkCommitBuildStatusSummaryRequest.Builder)new RefBulkCommitBuildStatusSummaryRequest.Builder(repository, new String[0]).commitIds(commitIds);
        if (!StringUtils.isBlank((CharSequence)ref)) {
            Ref resolvedRef = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(ref).build());
            if (resolvedRef == null) {
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.build.status.no.such.ref", new Object[0]));
            }
            requestBuilder.ref(resolvedRef);
        }
        return this.buildStatusService.getSummaries(requestBuilder.build());
    }

    private Map<Long, BuildSummary> getBulkPullRequestSummaries(Repository repository, List<Long> prIds) {
        BulkPullRequestBuildStatusSummaryRequest request = new BulkPullRequestBuildStatusSummaryRequest.Builder(repository, new Long[0]).pullRequestIds(prIds).build();
        return this.buildStatusService.getSummaries(request);
    }

    private Map<Ref, BuildSummary> getBulkRefSummaries(Repository repository, List<String> refs) {
        BulkRefBuildStatusSummaryRequest request = new BulkRefBuildStatusSummaryRequest.Builder(repository, new String[0]).refs(refs).build();
        return this.buildStatusService.getSummaries(request);
    }

    private Map<String, BuildSummary> getSummaries(Repository repository, List<String> commitIds, List<String> refs, List<Long> prIds) {
        if (!commitIds.isEmpty()) {
            return this.getBulkCommitSummaries(repository, commitIds, refs.isEmpty() ? null : refs.get(0));
        }
        if (!refs.isEmpty()) {
            return this.getBulkRefSummaries(repository, refs).entrySet().stream().collect(Collectors.toMap(entry -> ((Ref)entry.getKey()).getId(), Map.Entry::getValue));
        }
        if (!prIds.isEmpty()) {
            return this.getBulkPullRequestSummaries(repository, prIds).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
        }
        return Collections.emptyMap();
    }
}

