/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.codeowners;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.codeowners.CodeOwnersRequest;
import com.atlassian.bitbucket.dmz.codeowners.CodeOwnersResponse;
import com.atlassian.bitbucket.dmz.codeowners.DmzCodeOwnersService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.codeowners.RestCodeOwnersResponse;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/code-owners")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CodeOwnersResource {
    private static final Pattern REPOSITORY_PATTERN = Pattern.compile("(.*)\\/(.*)");
    private final DmzCodeOwnersService codeOwnersConfigService;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;

    @Inject
    public CodeOwnersResource(DmzCodeOwnersService codeOwnersConfigService, I18nService i18nService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.codeOwnersConfigService = codeOwnersConfigService;
        this.repositoryService = repositoryService;
    }

    @Operation(summary="Get code owners", description="Gets a list of owners for the changeset between the provided from ref and to ref.")
    @Parameters(value={@Parameter(name="sourceRepo", in=ParameterIn.QUERY, description="an optional parameter specifying the source repository containing the source ref. The parameter can be in the form of a repository ID <em>sourceRepo=42</em>, or by its project key plus it's repo slug separated by a slash: <em>sourceRepo=projectKey/repoSlug</em>. If no source repo is specified, the target repo is used instead."), @Parameter(name="sourceRefId", in=ParameterIn.QUERY, required=true, description="the source ref of the changeset. Can be a qualified or unqualified ref name."), @Parameter(name="targetRefId", in=ParameterIn.QUERY, required=true, description="the target ref of the changeset. Can be a qualified or unqualified ref name.")})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, representation=RestCodeOwnersResponse.class, documentation="The list of all code owners associated with the changeset between the source and target refs, up to the maximum specified in the system properties."), @ResponseDoc(responseCode=400, restError=true, documentation="The source ref was not provided, the target ref was not provided, or the source and target ref are the same ref in the same repository."), @ResponseDoc(responseCode=401, restError=true, documentation="The currently authenticated user has insufficient permissions to find code owners for the provided source and target refs."), @ResponseDoc(responseCode=404, restError=true, documentation="A ref matching the provided source or target ref could not be found, or a repository matching the provided source ref identifier could not be found.")})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCodeOwnersForDiff(@QueryParam(value="sourceRepo") String sourceRepoIdentifier, @QueryParam(value="sourceRefId") String sourceRefId, @BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="targetRefId") String targetRefId) {
        Repository sourceRepo = this.getSourceRepository(sourceRepoIdentifier).orElse(repositoryResolver.getRepository());
        List<RestErrorMessage> errorMessages = this.validateCodeOwnerRequest(sourceRepo, sourceRefId, repositoryResolver.getRepository(), targetRefId);
        if (!errorMessages.isEmpty()) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errorMessages)).build();
        }
        CodeOwnersResponse response = this.codeOwnersConfigService.getCodeOwners(new CodeOwnersRequest.Builder(sourceRefId, targetRefId, repositoryResolver.getRepository()).sourceRepository(sourceRepo).build());
        return ResponseFactory.ok((Object)((Object)new RestCodeOwnersResponse(response))).build();
    }

    private Optional<Repository> getSourceRepository(String sourceRepoIdentifier) {
        if (StringUtils.isBlank((CharSequence)sourceRepoIdentifier)) {
            return Optional.empty();
        }
        Matcher repoMatcher = REPOSITORY_PATTERN.matcher(sourceRepoIdentifier);
        if (repoMatcher.matches()) {
            String repositorySlug;
            String projectKey = repoMatcher.group(1);
            Repository sourceRepo = this.repositoryService.getBySlug(projectKey, repositorySlug = repoMatcher.group(2));
            if (sourceRepo == null) {
                throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyslug", new Object[]{projectKey, repositorySlug}), null);
            }
            return Optional.of(sourceRepo);
        }
        try {
            int repositoryId = Integer.parseInt(sourceRepoIdentifier);
            Repository sourceRepo = this.repositoryService.getById(repositoryId);
            if (sourceRepo == null) {
                throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyid", new Object[]{repositoryId}), null);
            }
            return Optional.of(sourceRepo);
        }
        catch (NumberFormatException formatException) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.code.owners.error.rest.source.repository.identifier.invalid", new Object[]{sourceRepoIdentifier}));
        }
    }

    private List<RestErrorMessage> validateCodeOwnerRequest(Repository sourceRepo, String sourceRefId, Repository targetRepo, String targetRefId) {
        ImmutableList.Builder errorMessages = new ImmutableList.Builder();
        if (StringUtils.isBlank((CharSequence)sourceRefId)) {
            errorMessages.add((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.code.owners.error.rest.source.ref.id.required", new Object[0])));
        }
        if (StringUtils.isBlank((CharSequence)targetRefId)) {
            errorMessages.add((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.code.owners.error.rest.target.ref.id.required", new Object[0])));
        }
        if (Objects.equals(targetRepo, sourceRepo) && Objects.equals(targetRefId, sourceRefId) && !StringUtils.isBlank((CharSequence)sourceRefId)) {
            errorMessages.add((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.code.owners.error.rest.source.target.ref.identical", new Object[0])));
        }
        return errorMessages.build();
    }
}

