/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.codeowners;

import com.atlassian.bitbucket.dmz.codeowners.CodeOwnersResponse;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;

@JsonSurrogate(value=CodeOwnersResponse.class)
public class RestCodeOwnersResponse
extends RestMapEntity {
    private static final String CODE_OWNERS = "codeOwners";
    private static final String ERROR_MESSAGES = "errorMessages";

    public RestCodeOwnersResponse() {
    }

    public RestCodeOwnersResponse(@Nonnull CodeOwnersResponse codeOwnersResponse) {
        this.put(CODE_OWNERS, codeOwnersResponse.getCodeOwners().stream().map(RestApplicationUser.REST_TRANSFORM).collect(Collectors.toList()));
        this.putIfNotEmpty(ERROR_MESSAGES, codeOwnersResponse.getErrorMessages());
    }

    public RestCodeOwnersResponse(@Nonnull List<RestApplicationUser> codeOwners, @Nonnull List<String> errorMessages) {
        this.put(CODE_OWNERS, codeOwners);
        this.putIfNotEmpty(ERROR_MESSAGES, errorMessages);
    }

    @ArraySchema(schema=@Schema(implementation=RestApplicationUser.class))
    @Nonnull
    public List<RestApplicationUser> getCodeOwners() {
        return (List)this.get(CODE_OWNERS);
    }

    @Nullable
    @Schema(example="CODEOWNERS file exceeds maximum file size- no code owners added.")
    public List<String> getErrorMessages() {
        return (List)this.get(ERROR_MESSAGES);
    }
}

