/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.dashboard;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dashboard.DashboardService;
import com.atlassian.bitbucket.dashboard.PullRequestSuggestion;
import com.atlassian.bitbucket.dashboard.SuggestPullRequestsRequest;
import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.BulkPullRequestBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.BulkRefBuildStatusSummaryRequest;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.dashboard.RestPullRequestSuggestionWithBuildStatus;
import com.atlassian.bitbucket.internal.rest.dashboard.RestPullRequestWithBuildStatus;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="dashboard")
@Singleton
public class InternalDashboardResource {
    private static final List<PullRequestOrder> DEFAULT_ORDER = ImmutableList.of((Object)PullRequestOrder.NEWEST);
    private final AuthenticationContext authenticationContext;
    private final DashboardService dashboardService;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final DmzPullRequestService pullRequestService;
    private final DmzBuildStatusService buildStatusService;

    @Inject
    public InternalDashboardResource(AuthenticationContext authenticationContext, DashboardService dashboardService, I18nService i18nService, PermissionValidationService permissionValidationService, DmzBuildStatusService buildStatusService, DmzPullRequestService pullRequestService) {
        this.i18nService = i18nService;
        this.authenticationContext = authenticationContext;
        this.dashboardService = dashboardService;
        this.permissionValidationService = permissionValidationService;
        this.buildStatusService = buildStatusService;
        this.pullRequestService = pullRequestService;
    }

    @GET
    @Path(value="pull-requests")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequests(@BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="state") String state, @QueryParam(value="role") List<String> roles, @QueryParam(value="participantStatus") String participantStatus, @QueryParam(value="order") List<String> orders, @QueryParam(value="closedSince") String closedSince) {
        this.permissionValidationService.validateAuthenticated();
        PullRequestSearchRequest request = this.buildSearchRequest(roles, state, participantStatus, orders, closedSince);
        Page pullRequestPage = this.pullRequestService.search(request, pageRequestResolver.getPageRequest());
        HashMap buildStatuses = new HashMap();
        pullRequestPage.stream().collect(Collectors.groupingBy(pullrequest -> pullrequest.getToRef().getRepository(), Collectors.mapping(PullRequest::getId, Collectors.toSet()))).forEach((repository, pullRequestIDs) -> buildStatuses.put(repository, this.buildStatusService.getSummaries(new BulkPullRequestBuildStatusSummaryRequest.Builder(repository, pullRequestIDs.toArray(new Long[0])).build())));
        return ResponseFactory.ok((Object)new RestPage(pullRequestPage, pullRequest -> {
            Map sums = buildStatuses.getOrDefault(pullRequest.getToRef().getRepository(), Collections.emptyMap());
            return new RestPullRequestWithBuildStatus((PullRequest)pullRequest, (BuildSummary)sums.get(pullRequest.getId()));
        })).build();
    }

    @GET
    @Path(value="pull-request-suggestions")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestSuggestions(@QueryParam(value="changesSince") @DefaultValue(value="172800") String changesSince, @QueryParam(value="limit") @DefaultValue(value="3") int limit) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        HashMap buildSummaries = new HashMap();
        Page suggestionsPage = this.dashboardService.suggestPullRequests(new SuggestPullRequestsRequest.Builder(currentUser, this.parseDateTimeOffset(changesSince)).limit(limit).build());
        suggestionsPage.stream().collect(Collectors.groupingBy(PullRequestSuggestion::getRepository, Collectors.mapping(sug -> sug.getFromRef().getId(), Collectors.toSet()))).forEach((repository, refIds) -> buildSummaries.put(repository, this.buildStatusService.getSummaries(new BulkRefBuildStatusSummaryRequest.Builder(repository, refIds).build())));
        return ResponseFactory.ok((Object)new RestPage(suggestionsPage, suggestion -> new RestPullRequestSuggestionWithBuildStatus((PullRequestSuggestion)suggestion, (BuildSummary)buildSummaries.getOrDefault(suggestion.getRepository(), Collections.emptyMap()).get(suggestion.getFromRef())))).build();
    }

    private PullRequestSearchRequest buildSearchRequest(List<String> roleParams, String stateParam, String participantStatusParam, List<String> orderParams, String closedSinceParam) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        Date closedSince = this.parseDateTimeOffset(closedSinceParam);
        List roles = roleParams.stream().map(this::parseRole).collect(Collectors.toList());
        PullRequestState state = this.parseState(stateParam);
        Set<PullRequestParticipantStatus> participantStatus = this.parseParticipantStatus(participantStatusParam);
        List<PullRequestOrder> orders = this.parseOrders(orderParams);
        List participants = roles.stream().map(role -> new PullRequestParticipantRequest.Builder(currentUser.getName()).role(role).statuses((Iterable)participantStatus).build()).collect(Collectors.toList());
        if (roles.size() < 1) {
            participants.add(new PullRequestParticipantRequest.Builder(currentUser.getName()).statuses(participantStatus).build());
        }
        return new PullRequestSearchRequest.Builder().orders(orders).participants(participants).state(state).closedSince(closedSince).build();
    }

    private Date parseDateTimeOffset(String value) {
        if (value == null) {
            return null;
        }
        try {
            long closedSince = Long.parseLong(value);
            if (closedSince < 0L) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.datetime.offset.invalid", new Object[]{value}));
            }
            return new Date(System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(closedSince));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.datetime.offset.invalid", new Object[]{value}));
        }
    }

    private List<PullRequestOrder> parseOrders(List<String> values) {
        if (values.isEmpty()) {
            return DEFAULT_ORDER;
        }
        ArrayList orders = Lists.newArrayList();
        values.forEach(value -> {
            try {
                orders.add(PullRequestOrder.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.order.invalid", new Object[]{value, Arrays.asList(PullRequestOrder.values())}));
            }
        });
        return orders;
    }

    private Set<PullRequestParticipantStatus> parseParticipantStatus(String value) {
        if (value == null) {
            return new HashSet<PullRequestParticipantStatus>(Arrays.asList(PullRequestParticipantStatus.values()));
        }
        return (Set)Arrays.stream(value.split(",")).map(this::toParticipantStatus).collect(MoreCollectors.toImmutableSet());
    }

    private PullRequestRole parseRole(String value) {
        if (value == null) {
            return null;
        }
        try {
            return PullRequestRole.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.role.invalid", new Object[]{value, Arrays.asList(PullRequestRole.values())}));
        }
    }

    private PullRequestState parseState(String value) {
        if (value == null) {
            return null;
        }
        try {
            return PullRequestState.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.state.invalid", new Object[]{value, Arrays.asList(PullRequestState.values())}));
        }
    }

    private PullRequestParticipantStatus toParticipantStatus(String value) {
        try {
            return PullRequestParticipantStatus.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.status.participant.invalid", new Object[]{value, Arrays.asList(PullRequestState.values())}));
        }
    }
}

