/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.deployment;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.deployments.CommitDeploymentSearchRequest;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.deployment.AbstractInternalDeploymentResource;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@UnrestrictedAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/deployments")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalCommitDeploymentResource
extends AbstractInternalDeploymentResource {
    @Inject
    public InternalCommitDeploymentResource(DeploymentService deploymentService, I18nService i18nService) {
        super(deploymentService, i18nService);
    }

    @GET
    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response search(@PathParam(value="commitId") String commitId, @BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="state") String state, @BeanParam PageRequestResolver pageRequestResolver) {
        CommitDeploymentSearchRequest searchRequest = ((CommitDeploymentSearchRequest.Builder)new CommitDeploymentSearchRequest.Builder(repositoryResolver.getRepository(), commitId).state(this.getState(state))).build();
        Page result = this.deploymentService.search(searchRequest, pageRequestResolver.getPageRequest());
        return this.toResponse((Page<Deployment>)result);
    }
}

