/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.mergequeue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/merge-queue")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class PullRequestMergeQueueResource {
    private final MergeQueueService mergeQueueService;

    @Inject
    public PullRequestMergeQueueResource(MergeQueueService mergeQueueService) {
        this.mergeQueueService = mergeQueueService;
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response removeFromQueue(@BeanParam PullRequestResolver pullRequestResolver) {
        this.mergeQueueService.removeFromQueue(pullRequestResolver.getPullRequest());
        return Response.noContent().build();
    }
}

