/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.mergequeue;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.QueuedPullRequestSearchRequest;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}/merge-queue")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class RepositoryMergeQueueResource {
    private final MergeQueueService mergeQueueService;

    @Inject
    public RepositoryMergeQueueResource(MergeQueueService mergeQueueService) {
        this.mergeQueueService = mergeQueueService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchQueuedPullRequests(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="toRefId") String toRefId) {
        Page queuedPullRequests = this.mergeQueueService.searchQueuedPullRequests(new QueuedPullRequestSearchRequest.Builder(repositoryResolver.getRepository().getId()).toRefId(toRefId).build(), pageRequestResolver.getPageRequest());
        return Response.ok((Object)new RestPage(queuedPullRequests, RestPullRequest.REST_TRANSFORM)).build();
    }
}

