/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.monitoring;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.monitoring.DmzMonitoringSettingsService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.monitoring.MonitoringSettings;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/monitoring/settings")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class MonitoringSettingsResource {
    private final I18nService i18nService;
    private final DmzMonitoringSettingsService monitoringSettingsService;

    @Inject
    public MonitoringSettingsResource(I18nService i18nService, DmzMonitoringSettingsService monitoringSettingsService) {
        this.i18nService = i18nService;
        this.monitoringSettingsService = monitoringSettingsService;
    }

    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setSettings(MonitoringSettings settings) {
        if (settings.getIpdMonitoringEnabled() == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.web.admin.settings.request.invalid", new Object[]{"Missing property 'ipdMonitoringEnabled'"}));
        }
        this.monitoringSettingsService.setIpdMonitoringEnabled(settings.getIpdMonitoringEnabled().booleanValue());
        return ResponseFactory.ok().build();
    }
}

