/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.internal.rest.pull.RestEnrichedPullRequestMergeability;
import com.atlassian.bitbucket.internal.rest.pull.RestPullRequestDraftRequest;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.automerge.AutoMergeService;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalPullRequestResource {
    private final AutoMergeService autoMergeService;
    private final MergeQueueService mergeQueueService;
    private final MergeQueueSettingsService mergeQueueSettingsService;
    private final DmzPullRequestService pullRequestService;

    @Inject
    public InternalPullRequestResource(AutoMergeService autoMergeService, MergeQueueService mergeQueueService, MergeQueueSettingsService mergeQueueSettingsService, DmzPullRequestService pullRequestService) {
        this.autoMergeService = autoMergeService;
        this.mergeQueueService = mergeQueueService;
        this.mergeQueueSettingsService = mergeQueueSettingsService;
        this.pullRequestService = pullRequestService;
    }

    @DELETE
    @Path(value="auto-merge")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelAutoMerge(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver) {
        this.autoMergeService.cancelAutoMerge(repositoryResolver.getRepository().getId(), pullRequestResolver.getPullRequest().getId(), AutoMergeCancelledReason.USER_CANCELLED_REQUEST);
        return this.canMerge(repositoryResolver, pullRequestResolver);
    }

    @GET
    @Path(value="merge")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response canMerge(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PullRequestResolver pullRequestResolver) {
        PullRequest pullRequest = pullRequestResolver.getPullRequest();
        PullRequestMergeability mergeability = this.pullRequestService.canMerge(repositoryResolver.getRepository().getId(), pullRequest.getId());
        boolean autoMergeEnabled = this.autoMergeService.isSettingEnabledForPullRequest(pullRequest);
        boolean autoMergeRequested = autoMergeEnabled && this.autoMergeService.getAutoMergeRequest(pullRequest).isPresent();
        boolean canRequestAutoMerge = autoMergeEnabled && !autoMergeRequested && !mergeability.isConflicted() && !mergeability.canMerge();
        boolean mergeQueueEnabled = this.mergeQueueSettingsService.isEnabled(pullRequest);
        boolean queued = this.mergeQueueService.isQueued(pullRequest);
        boolean canQueue = !queued && mergeQueueEnabled;
        RestEnrichedPullRequestMergeability response = new RestEnrichedPullRequestMergeability.Builder(mergeability).autoMergeRequested(autoMergeRequested).canRequestAutoMerge(canRequestAutoMerge).canQueue(canQueue).queued(queued).build();
        return ResponseFactory.ok((Object)((Object)response)).build();
    }

    @PUT
    @Path(value="draft")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateDraftStatus(@BeanParam PullRequestResolver pullRequestResolver, RestPullRequestDraftRequest request) {
        return ResponseFactory.ok().entity((Object)new RestPullRequest(this.pullRequestService.updateDraftStatus(pullRequestResolver.getPullRequest(), request.isDraft()))).build();
    }
}

