/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class RestEnrichedPullRequestMergeability
extends RestPullRequestMergeability {
    private static final String AUTO_MERGE_REQUESTED = "autoMergeRequested";
    private static final String CAN_QUEUE = "canQueue";
    private static final String CAN_REQUEST_AUTO_MERGE = "canRequestAutoMerge";
    private static final String QUEUED = "queued";

    private RestEnrichedPullRequestMergeability(Builder builder) {
        super(builder.mergeability);
        this.put(AUTO_MERGE_REQUESTED, builder.autoMergeRequested);
        this.put(CAN_QUEUE, builder.canQueue);
        this.put(CAN_REQUEST_AUTO_MERGE, builder.canRequestAutoMerge);
        this.put(QUEUED, builder.queued);
    }

    public boolean canQueue() {
        return this.getBoolProperty(CAN_QUEUE);
    }

    public boolean canRequestAutoMerge() {
        return this.getBoolProperty(CAN_REQUEST_AUTO_MERGE);
    }

    public boolean isAutoMergeRequested() {
        return this.getBoolProperty(AUTO_MERGE_REQUESTED);
    }

    public boolean isQueued() {
        return this.getBoolProperty(QUEUED);
    }

    public static class Builder {
        private final PullRequestMergeability mergeability;
        private boolean autoMergeRequested;
        private boolean canQueue;
        private boolean canRequestAutoMerge;
        private boolean queued;

        public Builder(@Nonnull PullRequestMergeability mergeability) {
            this.mergeability = Objects.requireNonNull(mergeability, "mergeability");
        }

        @Nonnull
        public Builder autoMergeRequested(boolean value) {
            this.autoMergeRequested = value;
            return this;
        }

        @Nonnull
        public RestEnrichedPullRequestMergeability build() {
            return new RestEnrichedPullRequestMergeability(this);
        }

        @Nonnull
        public Builder canQueue(boolean value) {
            this.canQueue = value;
            return this;
        }

        @Nonnull
        public Builder canRequestAutoMerge(boolean value) {
            this.canRequestAutoMerge = value;
            return this;
        }

        @Nonnull
        public Builder queued(boolean value) {
            this.queued = value;
            return this;
        }
    }
}

