/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull.reviewer;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.rest.pull.reviewer.ReviewerSearchService;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/reviewer-groups")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InternalReviewerGroupRepositoryResource {
    private final ReviewerSearchService reviewerSearchService;

    @Inject
    public InternalReviewerGroupRepositoryResource(ReviewerSearchService reviewerSearchService) {
        this.reviewerSearchService = reviewerSearchService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchReviewerGroupsAndUsers(@Context UriInfo uriInfo, @BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page<Object> pageOfResults = this.reviewerSearchService.searchReviewerGroupsAndUsers(uriInfo, scopeResolver.getScope(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(pageOfResults)).build();
    }
}

