/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.pull.template;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.rest.pull.template.PullRequestTemplateResourceHelper;
import com.atlassian.bitbucket.internal.rest.pull.template.RestPullRequestTemplate;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/pull-request-templates")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestTemplateProjectResource {
    private final PullRequestTemplateResourceHelper helper;

    @Inject
    public PullRequestTemplateProjectResource(PullRequestTemplateResourceHelper helper) {
        this.helper = helper;
    }

    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response create(@BeanParam ScopeResolver scopeResolver, RestPullRequestTemplate request) {
        return this.helper.create(scopeResolver.getScope(), request);
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam ScopeResolver scopeResolver) {
        return this.helper.delete(scopeResolver.getScope());
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getTemplate(@BeanParam ScopeResolver scopeResolver) {
        return this.helper.getTemplate(scopeResolver.getScope());
    }
}

