/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.micrometer.util.QualifiedCompatibleHierarchicalNameMapper;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class IpdUtils {
    public static final HierarchicalNameMapper DEFAULT_NAME_MAPPER = new QualifiedCompatibleHierarchicalNameMapper();

    private IpdUtils() {
    }

    public static MetricKey getProfilingKey(MeterKey meterKey) {
        return MetricKey.metricKey((String)meterKey.getName(), (MetricTag.RequiredMetricTag[])IpdUtils.getProfilingTags(meterKey.getTags()));
    }

    public static MetricTag.RequiredMetricTag[] getProfilingTags(MeterTag[] meterTags) {
        return (MetricTag.RequiredMetricTag[])Arrays.stream(meterTags).map(IpdUtils::getProfilingTag).toArray(MetricTag.RequiredMetricTag[]::new);
    }

    public static MetricTag getProfilingTag(MeterTag meterTag) {
        return MetricTag.of((String)meterTag.getKey(), (String)meterTag.getValue());
    }

    public static ObjectName constructObjectName(String productPrefix, MeterKey meterKey) {
        Meter.Id dummyMeterId = new Meter.Id(meterKey.getName(), IpdUtils.getMicrometerTags(meterKey.getTags()), null, null, Meter.Type.OTHER);
        String objectName = productPrefix + ":" + DEFAULT_NAME_MAPPER.toHierarchicalName(dummyMeterId, NamingConvention.dot);
        try {
            return new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static Tags getMicrometerTags(MeterTag[] tags) {
        return Tags.of((Iterable)Arrays.stream(tags).map(t -> Tag.of((String)t.getKey(), (String)t.getValue())).collect(Collectors.toList()));
    }
}

