/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistration;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAwareIpdJobRegistry
implements IpdJobRegistry {
    private static final Logger log = LoggerFactory.getLogger(PluginAwareIpdJobRegistry.class);
    protected final Set<Class<? extends IpdJob>> jobs = ConcurrentHashMap.newKeySet();
    private final IpdJobRegistry delegate;

    protected PluginAwareIpdJobRegistry(IpdJobRegistry delegate) {
        this.delegate = delegate;
    }

    public void register(@Nonnull IpdJob job, @Nonnull String key) {
        this.register(IpdJobRegistration.builder((IpdJob)job, (String)key).build());
    }

    public void register(@Nonnull IpdJobRegistration jobRegistration) {
        this.jobs.add(jobRegistration.getIpdJob().getClass());
        this.delegate.register(jobRegistration);
    }

    public void unregister(@Nonnull Class<? extends IpdJob> jobClass) {
        this.jobs.remove(jobClass);
        this.delegate.unregister(jobClass);
    }

    @PreDestroy
    public void preDestroy() {
        this.shutdown();
    }

    public void shutdown() {
        for (Class<? extends IpdJob> jobClass : this.jobs) {
            this.delegate.unregister(jobClass);
        }
        this.jobs.clear();
    }
}

