/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.internal.ipd.IpdUtils;
import com.atlassian.diagnostics.ipd.api.meters.AbstractIpdMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.Metrics;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IpdProfilingMeter
extends AbstractIpdMeter {
    private static final Logger LOG = LoggerFactory.getLogger(IpdProfilingMeter.class);
    protected final MBeanServer mBeanServer;
    protected final AtomicBoolean jmxRegistered;
    private final String[] allAttributes;
    private final String[] shortAttributes;
    protected final MetricKey profilingKey;

    protected IpdProfilingMeter(MeterConfig config, List<String> allAttributes, List<String> shortAttributes) {
        this(config, ManagementFactory.getPlatformMBeanServer(), allAttributes, shortAttributes);
    }

    protected IpdProfilingMeter(MeterConfig config, MBeanServer mBeanServer, List<String> allAttributes, List<String> shortAttributes) {
        super(config);
        this.mBeanServer = mBeanServer;
        this.allAttributes = allAttributes.toArray(new String[0]);
        this.shortAttributes = shortAttributes.toArray(new String[0]);
        this.jmxRegistered = new AtomicBoolean(false);
        this.profilingKey = IpdUtils.getProfilingKey(this.getMeterKey());
    }

    public Map<String, Object> getAttributes(boolean extraAttributes) {
        return this.getAttributes(extraAttributes, this.getObjectName());
    }

    protected Map<String, Object> getAttributes(boolean extraAttributes, ObjectName sourceObjectName) {
        if (!this.jmxRegistered.get()) {
            return Collections.emptyMap();
        }
        try {
            return this.mBeanServer.getAttributes(sourceObjectName, extraAttributes ? this.allAttributes : this.shortAttributes).asList().stream().filter(Objects::nonNull).collect(Collectors.toMap(IpdProfilingMeter::getKey, IpdProfilingMeter::getValue));
        }
        catch (InstanceNotFoundException e) {
            return Collections.emptyMap();
        }
        catch (ReflectionException e) {
            LOG.error(String.format("Couldn't read ATTRIBUTES for metric %s", this.getMeterKey()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static String getKey(Attribute attribute) {
        return String.format("_%s", StringUtils.uncapitalize((String)attribute.getName()));
    }

    private static String getValue(Attribute attribute) {
        return String.valueOf(attribute.getValue());
    }

    public boolean isVisible() {
        return this.isEnabled() && this.jmxRegistered.get();
    }

    public void unregisterMBean() {
        if (!this.jmxRegistered.compareAndSet(true, false)) {
            return;
        }
        try {
            Metrics.resetMetric((MetricKey)this.profilingKey);
            LOG.debug("Unregistering metric: {}", (Object)this.getMeterKey());
        }
        catch (Exception e) {
            LOG.error("Couldn't unregister metric: {} due to error.", (Object)this.getMeterKey(), (Object)e);
        }
    }

    public void registerMBean() {
        if (!this.isEnabled()) {
            return;
        }
        this.jmxRegistered.set(true);
    }
}

