/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.internal.ipd.metrics.IpdProfilingMeter;
import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.Metrics;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StatsMeterImpl
extends IpdProfilingMeter
implements StatsMeter {
    public static final List<String> FULL_ATTRIBUTES = ImmutableList.of((Object)"50thPercentile", (Object)"75thPercentile", (Object)"95thPercentile", (Object)"98thPercentile", (Object)"999thPercentile", (Object)"99thPercentile", (Object)"Count", (Object)"DurationUnit", (Object)"FifteenMinuteRate", (Object)"FiveMinuteRate", (Object)"Max", (Object)"Min", (Object[])new String[]{"Mean", "MeanRate", "OneMinuteRate", "RateUnit", "StdDev", "Value"});
    public static final List<String> SHORT_ATTRIBUTES = ImmutableList.of((Object)"99thPercentile", (Object)"Count", (Object)"Max", (Object)"Min", (Object)"Mean");
    private final MetricTimer micrometerMetric;
    private static final MeterFactory<StatsMeter> staticFactory = new MeterFactory(StatsMeterImpl::new, "stats", "statistics");

    protected StatsMeterImpl(MeterConfig config) {
        super(config, FULL_ATTRIBUTES, SHORT_ATTRIBUTES);
        this.micrometerMetric = Metrics.metric((String)this.getMeterKey().getName()).tags((Iterable)this.profilingKey.getTags()).timer();
    }

    public void update(long value, TimeUnit timeUnit) {
        if (this.isEnabled()) {
            this.micrometerMetric.update(value, timeUnit);
            this.metricUpdated();
        }
    }

    public static MeterFactory<StatsMeter> factory() {
        return staticFactory;
    }
}

