/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.tag;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.internal.tag.TagService;
import com.atlassian.bitbucket.internal.tag.idx.TagIndexer;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTagService
implements TagService {
    private static final String PROP_MAX_TAGS_PER_PAGE = "plugin.tag.index.page.max.tags";
    private static final String TAG_INDEX_PLUGIN_TOPIC = "tag-index";
    private static final Logger log = LoggerFactory.getLogger(DefaultTagService.class);
    private final int maxTagsPerPage;
    private final Topic<Integer> reindexTopic;
    private final TagIndexer tagIndexer;
    private String subscriptionId;

    public DefaultTagService(ApplicationPropertiesService propertiesService, RefService refService, RepositorySupplier repositorySupplier, SecurityService securityService, StorageService storageService, TopicService topicService) {
        this.tagIndexer = new TagIndexer(propertiesService, refService, repositorySupplier, securityService, storageService);
        this.maxTagsPerPage = propertiesService.getPluginProperty(PROP_MAX_TAGS_PER_PAGE, 500);
        this.reindexTopic = topicService.getTopic(TAG_INDEX_PLUGIN_TOPIC, new TopicSettings.Builder(Integer.class).dedupePendingMessages(true).build());
    }

    @Override
    @Nonnull
    public Page<Ref> findByCommits(@Nonnull Repository repository, @Nonnull Iterable<String> commitIds) {
        Iterable<Tag> matches = this.tagIndexer.readIndex(repository, this.maxTagsPerPage + 1, Sets.newHashSet(commitIds));
        return PageUtils.createPage(matches, (PageRequest)PageUtils.newRequest((int)0, (int)this.maxTagsPerPage));
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        if (event.isMaybeNetworkPartitionResolved()) {
            this.tagIndexer.clearAll();
        }
    }

    public void onDestroy() {
        if (this.subscriptionId != null) {
            this.reindexTopic.unsubscribe(this.subscriptionId);
            log.trace("Canceled subscription to tag reindex notifications", (Object)this.subscriptionId);
            this.subscriptionId = null;
        }
        this.tagIndexer.destroy();
    }

    public void onInit() {
        this.tagIndexer.init();
        this.subscriptionId = this.reindexTopic.subscribe(event -> {
            Integer repositoryId = (Integer)event.getMessage();
            log.debug("{}: Scheduling tag reindexing", (Object)repositoryId);
            this.tagIndexer.scheduleReindex(repositoryId);
        });
        log.trace("Subscribed to tag reindex notifications: {}", (Object)this.subscriptionId);
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        Collection refChanges = event.getRefChanges();
        if (refChanges.isEmpty()) {
            log.debug("{}: Ignoring event with no ref changes", (Object)repository);
        } else if (refChanges.stream().anyMatch(refChange -> refChange.getRef().getType() == StandardRefType.TAG)) {
            log.debug("{}: Triggering reindexing after tag change(s)", (Object)repository);
            this.reindexTopic.publish((Serializable)Integer.valueOf(repository.getId()));
        } else if (log.isDebugEnabled()) {
            String changes = refChanges.stream().limit(10L).map(refChange -> String.valueOf(refChange) + " [" + String.valueOf(refChange.getRef().getType()) + "]").collect(Collectors.joining("\n"));
            log.debug("{}: Ignoring {} ref changes; no tags were changed\n{}", new Object[]{repository, refChanges.size(), changes});
        }
    }
}

