/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.tag.idx;

import com.atlassian.bitbucket.internal.tag.idx.TagIndexConstants;
import com.atlassian.bitbucket.repository.SimpleTag;
import com.atlassian.bitbucket.repository.Tag;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.codec.binary.Hex;

public class TagIndexReader
extends OutputStream {
    private static final State SKIPPING_REMAINING_DATA = new State(){

        @Override
        public State process(int data) {
            return this;
        }
    };
    private final State SKIPPING_REF_ID = new State(){

        @Override
        public State process(int data) {
            return data == TagIndexConstants.REF_SEPERATOR ? new ReadingCommitId() : this;
        }
    };
    private final CountDownLatch latch;
    private final List<Tag> matched;
    private final int maxMatches;
    private final Set<String> toMatch;
    private State state;

    public TagIndexReader(Set<String> toMatch, int maxMatches) {
        this.toMatch = toMatch;
        this.maxMatches = maxMatches;
        this.latch = new CountDownLatch(1);
        this.matched = new ArrayList<Tag>();
        this.state = new ReadingCommitId();
    }

    @Override
    public void close() {
        this.latch.countDown();
    }

    public Iterable<Tag> getMatches() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Latch await interrupted", e);
        }
        return this.matched;
    }

    @Override
    public void write(int data) {
        this.state = this.state.process(data);
    }

    private String decodeId(ByteArrayOutputStream buffer) {
        try {
            return buffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface State {
        public State process(int var1);
    }

    private class ReadingCommitId
    implements State {
        private static final int ENCODED_COMMIT_ID_SIZE = 20;
        private final byte[] buffer = new byte[20];
        private int pos = 0;

        private ReadingCommitId() {
        }

        @Override
        public State process(int data) {
            if (this.pos < 20) {
                this.buffer[this.pos++] = (byte)data;
                return this;
            }
            String commitId = Hex.encodeHexString((byte[])this.buffer);
            if (TagIndexReader.this.toMatch.contains(commitId)) {
                return new ReadingRefId(commitId).process(data);
            }
            return TagIndexReader.this.SKIPPING_REF_ID.process(data);
        }
    }

    private class ReadingRefId
    implements State {
        private final ByteArrayOutputStream buffer;
        private final String commitId;
        private String displayId;

        public ReadingRefId(String commitId) {
            this.commitId = commitId;
            this.buffer = new ByteArrayOutputStream();
        }

        @Override
        public State process(int data) {
            if (data != TagIndexConstants.REF_SEPERATOR && data != TagIndexConstants.ID_SEPERATOR) {
                this.buffer.write(data);
                return this;
            }
            if (data == TagIndexConstants.ID_SEPERATOR) {
                this.displayId = TagIndexReader.this.decodeId(this.buffer);
                this.buffer.reset();
                return this;
            }
            String id = TagIndexReader.this.decodeId(this.buffer);
            TagIndexReader.this.matched.add((Tag)((SimpleTag.Builder)((SimpleTag.Builder)((SimpleTag.Builder)new SimpleTag.Builder().displayId(this.displayId)).latestCommit(this.commitId)).id(id)).build());
            return TagIndexReader.this.matched.size() < TagIndexReader.this.maxMatches ? new ReadingCommitId() : SKIPPING_REMAINING_DATA;
        }
    }
}

