/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.tag.idx;

import com.atlassian.bitbucket.internal.tag.idx.TagIndexConstants;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.repository.TagCallback;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class TagIndexWriter
implements TagCallback {
    private final OutputStream target;

    public TagIndexWriter(OutputStream target) {
        this.target = target;
    }

    public boolean onTag(@Nonnull Tag tag) throws IOException {
        this.writeRef((Ref)tag);
        return true;
    }

    private void writeRef(@Nonnull Ref ref) {
        try {
            this.target.write(Hex.decodeHex((char[])ref.getLatestCommit().toCharArray()));
            this.target.write(ref.getDisplayId().getBytes("UTF-8"));
            this.target.write(TagIndexConstants.ID_SEPERATOR.byteValue());
            this.target.write(ref.getId().getBytes("UTF-8"));
            this.target.write(TagIndexConstants.REF_SEPERATOR.byteValue());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Failed to hex decode " + ref.getLatestCommit(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

