/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.tag.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.tag.TagService;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRef;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/tags")
@Singleton
public class TagResource {
    private final TagService tagService;

    @Inject
    public TagResource(TagService tagService) {
        this.tagService = tagService;
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findByCommits(@BeanParam RepositoryResolver repositoryResolver, Set<String> commitIds) {
        Page<Ref> tags = this.tagService.findByCommits(repositoryResolver.getRepository(), commitIds);
        return ResponseFactory.ok((Object)new RestPage(tags, RestRef.REST_TRANSFORM)).build();
    }
}

