/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.concurrent;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerBlocksPolicy
implements RejectedExecutionHandler {
    private static final Logger log = LoggerFactory.getLogger(CallerBlocksPolicy.class);
    private final long timeoutMs;

    public CallerBlocksPolicy(@Nonnull Duration timeout) {
        this.timeoutMs = Objects.requireNonNull(timeout, "timeout").toMillis();
    }

    @Override
    public void rejectedExecution(@Nonnull Runnable runnable, @Nonnull ThreadPoolExecutor executor) {
        if (executor.isShutdown()) {
            throw new RejectedExecutionException("Executor has been shut down");
        }
        try {
            log.debug("All pool threads are busy; queuing task with {} ms timeout", (Object)this.timeoutMs);
            long start = System.nanoTime();
            if (!executor.getQueue().offer(runnable, this.timeoutMs, TimeUnit.MILLISECONDS)) {
                throw new RejectedExecutionException("Timed out queuing task; all threads are busy");
            }
            log.debug("Task was queued after {} ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException("Interrupted while queuing task", e);
        }
    }
}

