/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.io;

import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteUtils {
    private ByteUtils() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static boolean copy(@Nonnull ByteBuffer src, @Nonnull ByteBuffer dst) {
        Objects.requireNonNull(src, "src");
        Objects.requireNonNull(dst, "dst");
        int available = dst.remaining();
        if (src.remaining() > available) {
            ByteBuffer slice = src.slice();
            slice.limit(available);
            dst.put(slice);
            src.position(src.position() + available);
            return false;
        }
        dst.put(src);
        return true;
    }
}

