/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.io;

import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoThrottle {
    private static final Logger log = LoggerFactory.getLogger(IoThrottle.class);
    private final long bytesPerSecond;
    private final long nanosPerByte;
    private final long startTimestamp;
    private final AtomicLong totalBytesProcessed;
    private volatile boolean canceled;
    private volatile Thread parkedThread;

    private IoThrottle(long bytesPerSecond) {
        this.bytesPerSecond = bytesPerSecond;
        this.nanosPerByte = bytesPerSecond > 0L ? TimeUnit.SECONDS.toNanos(1L) / bytesPerSecond : -1L;
        this.startTimestamp = System.nanoTime();
        this.totalBytesProcessed = new AtomicLong();
    }

    @Nonnull
    public static IoThrottle start(long bytesPerSecond) {
        return new IoThrottle(bytesPerSecond);
    }

    public void cancel() {
        this.canceled = true;
        Thread thread = this.parkedThread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public void maybeThrottle(long bytesProcessed) {
        if (this.canceled) {
            return;
        }
        if (this.nanosPerByte > 0L) {
            long pauseNanos;
            long bytes = this.totalBytesProcessed.addAndGet(bytesProcessed);
            long nextEmitTimestamp = this.startTimestamp + this.nanosPerByte * bytes;
            while (!this.canceled && (pauseNanos = nextEmitTimestamp - System.nanoTime()) > 0L) {
                if (log.isTraceEnabled()) {
                    long sleepMs = TimeUnit.NANOSECONDS.toMillis(pauseNanos);
                    long timeSinceStart = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimestamp);
                    log.trace("Throttling file processing; parking for {}ms before sending next message (current rate = {} bytes/s, target rate = {} bytes/s)", new Object[]{sleepMs, (double)bytes * 1000.0 / (double)timeSinceStart, this.bytesPerSecond});
                }
                this.parkedThread = Thread.currentThread();
                LockSupport.parkNanos(pauseNanos);
            }
        }
    }
}

