/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.io;

import com.atlassian.bitbucket.mesh.io.PathWithAttributes;
import com.atlassian.bitbucket.mesh.io.PruneStaleFileCallback;
import com.atlassian.bitbucket.mesh.io.SetFilePermissionRequest;
import com.atlassian.bitbucket.mesh.io.SyncFileTreeCallback;
import com.atlassian.bitbucket.mesh.io.SyncFileTreeParameters;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreFiles {
    private static final CopyOption[] COPY_OPTIONS_ATTRIBUTES = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
    private static final CopyOption[] COPY_OPTIONS_ATTRIBUTES_AND_REPLACE = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
    private static final Path PATH_TRAVERSAL = Paths.get("..", new String[0]);
    private static final Pattern PATH_UNSAFE = Pattern.compile("[^\\p{Alnum}\\-._]+");
    private static final Logger log = LoggerFactory.getLogger(MoreFiles.class);

    private MoreFiles() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static boolean canOpen(@Nonnull Path path) {
        boolean bl;
        block8: {
            Objects.requireNonNull(path, "path");
            InputStream ignored = Files.newInputStream(path, new OpenOption[0]);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    public static void cleanDirectory(@Nonnull Path directory) throws IOException {
        Objects.requireNonNull(directory, "directory");
        try (Stream<Path> entries = Files.list(directory);){
            for (Path entry : entries::iterator) {
                BasicFileAttributes attributes = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.isDirectory()) {
                    MoreFiles.deleteRecursively(entry);
                    continue;
                }
                Files.delete(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFileAtomic(@Nonnull Path source, @Nonnull Path destination, boolean replace) throws IOException {
        if (!replace && Files.isRegularFile(destination, new LinkOption[0])) {
            return false;
        }
        Path tmpObject = Files.createTempFile(destination.getParent(), "atl-", null, new FileAttribute[0]);
        try {
            Files.copy(source, tmpObject, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            try {
                Files.move(tmpObject, destination, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                if (!replace && Files.isRegularFile(destination, new LinkOption[0])) {
                    boolean bl = false;
                    try {
                        Files.delete(tmpObject);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                    return bl;
                }
                throw e;
            }
        }
        finally {
            try {
                Files.delete(tmpObject);
            }
            catch (NoSuchFileException noSuchFileException) {}
        }
        return true;
    }

    public static boolean createHardLink(@Nonnull Path path, @Nonnull Path existing, boolean replace) throws IOException {
        try {
            Files.createLink(path, existing);
        }
        catch (FileAlreadyExistsException e) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw e;
            }
            if (!replace) {
                return false;
            }
            if (Files.isSameFile(path, existing)) {
                return true;
            }
            Path tmpFile = path.resolveSibling("atl-" + String.valueOf(path.getFileName()) + "-" + System.nanoTime());
            try {
                Files.createLink(tmpFile, existing);
                Files.move(tmpFile, path, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException innerException) {
                throw e;
            }
            finally {
                try {
                    Files.delete(tmpFile);
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean createHardLinkOrCopy(@Nonnull Path path, @Nonnull Path existing, boolean replace) throws IOException {
        try {
            return MoreFiles.createHardLink(path, existing, replace);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return MoreFiles.copyFileAtomic(existing, path, replace);
        }
    }

    public static void deleteNowOrOnExit(@Nonnull Path path) {
        try {
            MoreFiles.deleteRecursively(path);
        }
        catch (IOException ignored) {
            MoreFiles.deleteOnExit(path);
        }
    }

    public static void deleteOnExit(@Nonnull Path path) {
        Objects.requireNonNull(path, "path").toFile().deleteOnExit();
    }

    public static boolean deleteQuietly(@Nonnull Path path) {
        try {
            MoreFiles.deleteRecursively(path);
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public static void deleteRecursively(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return this.deleteIfExists(dir);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return this.deleteIfExists(file);
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof FileNotFoundException || exc instanceof NoSuchFileException) {
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }

            private FileVisitResult deleteIfExists(Path path) throws IOException {
                try {
                    Files.delete(path);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean dirExists(@Nonnull Path dir) {
        boolean bl;
        block8: {
            Objects.requireNonNull(dir, "dir");
            Stream<Path> ignored = Files.list(dir);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored2) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    @Nonnull
    public static Duration getDurationSinceLastModified(@Nonnull Path file) {
        return Duration.ofMillis(System.currentTimeMillis() - MoreFiles.getLastModified(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Instant getFileSystemTime(@Nonnull Path directory) throws IOException {
        Path tmpFile = Files.createTempFile(directory, "filetime-check", null, new FileAttribute[0]);
        try {
            BasicFileAttributes attrs = Files.readAttributes(tmpFile, BasicFileAttributes.class, new LinkOption[0]);
            long fileTime = attrs.lastModifiedTime().toMillis();
            if (fileTime <= 0L) {
                fileTime = attrs.creationTime().toMillis();
            }
            Instant instant = fileTime > 0L ? Instant.ofEpochMilli(fileTime) : Instant.now();
            return instant;
        }
        finally {
            MoreFiles.deleteQuietly(tmpFile);
        }
    }

    public static long getLastModified(@Nonnull Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ignored) {
            return 0L;
        }
    }

    public static boolean hasFileDirConflictInPath(@Nonnull Path file) {
        Objects.requireNonNull(file, "file");
        for (Path parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!Files.isRegularFile(parent, new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPosixSupported(@Nonnull Path path) throws IOException {
        return Files.getFileStore(path).supportsFileAttributeView("posix");
    }

    public static boolean isSameFileStore(@Nonnull Path path, @Nonnull Path other) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(other, "other");
        return Files.getFileStore(path).equals(Files.getFileStore(other));
    }

    public static boolean isWithin(@Nonnull Path path, @Nonnull Path expectedParent) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(expectedParent, "expectedParent");
        for (Path p : path) {
            if (!PATH_TRAVERSAL.equals(p)) continue;
            return MoreFiles.toRealPath(path).startsWith(expectedParent.toRealPath(new LinkOption[0]));
        }
        return path.startsWith(expectedParent);
    }

    @Nonnull
    public static Iterator<PathWithAttributes> iterateFileTreeSorted(@Nonnull Path start) {
        return new PathWithAttributesIterator(start, Comparator.naturalOrder());
    }

    @Nonnull
    public static Iterator<PathWithAttributes> iterateFileTreeSorted(@Nonnull Path start, @Nonnull Comparator<Path> comparator) {
        return new PathWithAttributesIterator(start, comparator);
    }

    @Nonnull
    public static Path mkdir(@Nonnull Path directory) {
        Objects.requireNonNull(directory, "directory");
        try {
            return Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException && Files.isDirectory(directory, new LinkOption[0])) {
                return directory;
            }
            throw new IllegalStateException("Could not create " + String.valueOf(directory.toAbsolutePath()), e);
        }
    }

    @Nonnull
    public static Path mkdir(@Nonnull Path parent, @Nonnull String child) {
        Objects.requireNonNull(parent, "parent");
        if (Objects.requireNonNull(child, "child").trim().isEmpty()) {
            throw new IllegalArgumentException("A path for the created directory is required");
        }
        return MoreFiles.mkdir(parent.resolve(child));
    }

    @Nonnull
    public static String pathSafe(@Nonnull String value) {
        return PATH_UNSAFE.matcher(value).replaceAll("-");
    }

    public static void pruneEmptyDirectories(final @Nonnull Path path) throws IOException {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private final Set<Path> dirsWithFiles = new HashSet<Path>();

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Path parent = file.getParent();
                    while (!parent.equals(path) && this.dirsWithFiles.add(parent)) {
                        parent = parent.getParent();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (!this.dirsWithFiles.remove(dir) && !path.equals(dir)) {
                        try {
                            Files.delete(dir);
                        }
                        catch (FileNotFoundException | DirectoryNotEmptyException | NoSuchFileException iOException) {
                        }
                        catch (IOException e) {
                            log.debug("Could not delete empty directory {}", (Object)dir, (Object)e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    public static void pruneStaleFiles(final @Nonnull Path path, @Nonnull Instant timestamp, final boolean pruneEmptyDirs, final @Nonnull PruneStaleFileCallback callback) throws IOException {
        Objects.requireNonNull(callback, "callback");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(timestamp, "timestamp");
        long gracePeriod = Math.max(1000L, Long.getLong("atl.mesh.stale.file.grace.millis", 60000L));
        final long timestampMillis = timestamp.toEpochMilli() - gracePeriod;
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (pruneEmptyDirs && !path.equals(dir)) {
                        try {
                            BasicFileAttributes attrs = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]);
                            Files.delete(dir);
                            callback.onDeleted(dir, attrs);
                        }
                        catch (FileNotFoundException | DirectoryNotEmptyException | NoSuchFileException attrs) {
                        }
                        catch (IOException e) {
                            callback.onError(path, e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    long lastModifiedMillis = attrs.lastModifiedTime().toMillis();
                    if (lastModifiedMillis > 0L && lastModifiedMillis < timestampMillis) {
                        try {
                            Files.delete(file);
                            callback.onDeleted(file, attrs);
                        }
                        catch (FileNotFoundException | NoSuchFileException iOException) {
                        }
                        catch (IOException e) {
                            callback.onError(path, e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public static void requireWithin(@Nonnull Path path, @Nonnull Path expectedParent) throws IOException {
        if (!MoreFiles.isWithin(path, expectedParent)) {
            throw new IllegalArgumentException(String.valueOf(path) + " is not contained within " + String.valueOf(expectedParent));
        }
    }

    @Nonnull
    public static Path resolve(@Nonnull Path path, @Nonnull String first, String ... more) {
        return Objects.requireNonNull(path, "path").resolve(Paths.get(first, more));
    }

    public static void setPermissions(@Nonnull SetFilePermissionRequest request) throws IOException {
        Path path = Objects.requireNonNull(request, "request").getPath();
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("The provided file, " + String.valueOf(path) + ", does not exist or is not a file");
        }
        FileStore fileStore = Files.getFileStore(path);
        if (!fileStore.supportsFileAttributeView("posix")) {
            throw new IOException("Could not update file permissions for " + String.valueOf(path.toAbsolutePath()) + "; the file store (" + String.valueOf(fileStore) + ") does not support POSIX permissions");
        }
        Files.setPosixFilePermissions(path, MoreFiles.toPosixFilePermissions(request));
    }

    public static long size(@Nonnull Path path) {
        Objects.requireNonNull(path, "path");
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static void syncFileTree(final @Nonnull SyncFileTreeParameters parameters) throws IOException {
        final Path source = parameters.getSource();
        final Path destination = parameters.getDestination();
        final Instant modifiedSince = (Instant)MoreObjects.firstNonNull((Object)parameters.getModifiedSince(), (Object)Instant.MIN);
        final SyncFileTreeCallback callback = parameters.getCallback();
        if (parameters.isDetectMissing() && Files.exists(destination, new LinkOption[0])) {
            Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (callback.isDestinationIncluded(dir, attrs)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path sourceFile = source.resolve(destination.relativize(file));
                    if (callback.isDestinationIncluded(file, attrs) && !Files.exists(sourceFile, new LinkOption[0])) {
                        callback.onMissingInSource(sourceFile, file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (exc instanceof NoSuchFileException || exc instanceof FileNotFoundException) {
                        log.debug("Concurrent delete detected: {}", (Object)exc.getMessage());
                        return FileVisitResult.CONTINUE;
                    }
                    return super.visitFileFailed(file, exc);
                }
            });
        }
        if (Files.exists(source, new LinkOption[0])) {
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private final boolean replace;
                private boolean tryAtomicCopy;
                private boolean tryHardLinks;
                {
                    this.replace = parameters.isReplaceExisting();
                    this.tryAtomicCopy = true;
                    this.tryHardLinks = parameters.isAllowHardLinks();
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block3: {
                        if (callback.isSourceIncluded(dir, attrs)) {
                            Path destDir = destination.resolve(source.relativize(dir));
                            try {
                                MoreFiles.mkdir(destDir);
                                return FileVisitResult.CONTINUE;
                            }
                            catch (IllegalStateException e) {
                                if (!Files.isRegularFile(destDir, new LinkOption[0])) break block3;
                                callback.onConflict(dir, attrs, destDir);
                            }
                        }
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.lastModifiedTime().toInstant().isAfter(modifiedSince) && callback.isSourceIncluded(file, attrs)) {
                        Path destinationFile = destination.resolve(source.relativize(file));
                        try {
                            this.hardLinkOrCopy(file, attrs, destinationFile);
                        }
                        catch (IOException e) {
                            callback.onError(file, attrs, destinationFile, e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (exc instanceof NoSuchFileException || exc instanceof FileNotFoundException) {
                        log.debug("Concurrent delete detected: {}", (Object)exc.getMessage());
                        return FileVisitResult.CONTINUE;
                    }
                    return super.visitFileFailed(file, exc);
                }

                private void hardLinkOrCopy(Path srcFile, BasicFileAttributes srcAttributes, Path destFile) throws IOException {
                    if (Files.isDirectory(destFile, new LinkOption[0])) {
                        callback.onConflict(srcFile, srcAttributes, destFile);
                        return;
                    }
                    if (this.tryHardLinks) {
                        try {
                            if (MoreFiles.createHardLink(destFile, srcFile, this.replace)) {
                                callback.onSynced(srcFile, srcAttributes, destFile);
                            } else {
                                callback.onConflict(srcFile, srcAttributes, destFile);
                            }
                            return;
                        }
                        catch (UnsupportedOperationException e) {
                            this.tryHardLinks = false;
                        }
                    }
                    if (this.tryAtomicCopy) {
                        try {
                            if (MoreFiles.copyFileAtomic(srcFile, destFile, this.replace)) {
                                callback.onSynced(srcFile, srcAttributes, destFile);
                            } else {
                                callback.onConflict(srcFile, srcAttributes, destFile);
                            }
                            return;
                        }
                        catch (AtomicMoveNotSupportedException e) {
                            this.tryAtomicCopy = false;
                        }
                    }
                    try {
                        Files.copy(srcFile, destFile, this.replace ? COPY_OPTIONS_ATTRIBUTES_AND_REPLACE : COPY_OPTIONS_ATTRIBUTES);
                        callback.onSynced(srcFile, srcAttributes, destFile);
                    }
                    catch (FileAlreadyExistsException e) {
                        callback.onConflict(srcFile, srcAttributes, destFile);
                    }
                }
            });
        }
    }

    public static long totalSize(@Nonnull Path path) {
        Objects.requireNonNull(path, "path");
        try {
            final MutableLong size = new MutableLong();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.add(attrs.size());
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException ignored) {
            return 0L;
        }
    }

    public static void touch(@Nonnull Path path) throws IOException {
        try {
            Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    public static void touch(@Nonnull Path path, @Nonnull Instant timestamp) throws IOException {
        FileTime fileTime = FileTime.from(timestamp);
        try {
            Files.setLastModifiedTime(path, fileTime);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            Files.createFile(path, new FileAttribute[0]);
            Files.setLastModifiedTime(path, fileTime);
        }
    }

    @Nonnull
    public static Path toRealPath(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return Paths.get(path.toFile().getCanonicalPath(), new String[0]);
        }
    }

    @Nonnull
    public static String toString(@Nonnull Path path) throws IOException {
        return MoreFiles.toString(path, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static String toString(@Nonnull Path path, @Nonnull Charset charset) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(charset, "charset");
        return new String(Files.readAllBytes(path), charset);
    }

    public static void walkFileTreeSorted(@Nonnull Path start, @Nonnull FileVisitor<? super Path> visitor) throws IOException {
        MoreFiles.walkFileTreeSorted(start, Comparator.naturalOrder(), visitor);
    }

    public static void walkFileTreeSorted(@Nonnull Path start, @Nonnull Comparator<Path> comparator, @Nonnull FileVisitor<? super Path> visitor) throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(start, BasicFileAttributes.class, new LinkOption[0]);
        if (attributes.isDirectory()) {
            if (visitor.preVisitDirectory(start, attributes) == FileVisitResult.CONTINUE) {
                MoreFiles.walkDirSorted(start, comparator, visitor);
                visitor.postVisitDirectory(start, null);
            }
        } else {
            visitor.visitFile(start, attributes);
        }
    }

    @Nonnull
    public static Path write(@Nonnull Path path, @Nonnull String value, OpenOption ... options) throws IOException {
        return MoreFiles.write(path, value, StandardCharsets.UTF_8, options);
    }

    @Nonnull
    public static Path write(@Nonnull Path path, @Nonnull String value, @Nonnull Charset charset, OpenOption ... options) throws IOException {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(charset, "charset");
        return Files.write(path, value.getBytes(charset), options);
    }

    private static List<PathWithAttributes> listDirSorted(Path path, Comparator<Path> comparator) throws IOException {
        ArrayList<PathWithAttributes> result = new ArrayList<PathWithAttributes>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            stream.forEach(p -> result.add(new PathWithAttributes((Path)p)));
        }
        result.sort(Comparator.comparing(PathWithAttributes::getPath, comparator));
        return result;
    }

    private static Set<PosixFilePermission> toPosixFilePermissions(SetFilePermissionRequest request) {
        ImmutableSet.Builder posixPermissions = ImmutableSet.builder();
        request.getOwnerPermissions().stream().map(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return PosixFilePermission.OWNER_EXECUTE;
                }
                case READ: {
                    return PosixFilePermission.OWNER_READ;
                }
            }
            return PosixFilePermission.OWNER_WRITE;
        }).forEach(arg_0 -> ((ImmutableSet.Builder)posixPermissions).add(arg_0));
        request.getGroupPermissions().stream().map(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return PosixFilePermission.GROUP_EXECUTE;
                }
                case READ: {
                    return PosixFilePermission.GROUP_READ;
                }
            }
            return PosixFilePermission.GROUP_WRITE;
        }).forEach(arg_0 -> ((ImmutableSet.Builder)posixPermissions).add(arg_0));
        request.getWorldPermissions().stream().map(permission -> {
            switch (permission) {
                case EXECUTE: {
                    return PosixFilePermission.OTHERS_EXECUTE;
                }
                case READ: {
                    return PosixFilePermission.OTHERS_READ;
                }
            }
            return PosixFilePermission.OTHERS_WRITE;
        }).forEach(arg_0 -> ((ImmutableSet.Builder)posixPermissions).add(arg_0));
        return posixPermissions.build();
    }

    private static boolean walkDirSorted(final Path path, Comparator<Path> comparator, final FileVisitor<? super Path> visitor) throws IOException {
        final TreeMap attributes = new TreeMap(comparator);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (dir.equals(path)) {
                    return FileVisitResult.CONTINUE;
                }
                attributes.put(dir, attrs);
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                attributes.put(file, attrs);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return visitor.visitFileFailed(file, exc);
            }
        });
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            it.remove();
            Path file = (Path)entry.getKey();
            BasicFileAttributes attrs = (BasicFileAttributes)entry.getValue();
            if (attrs.isDirectory()) {
                switch (visitor.preVisitDirectory(file, attrs)) {
                    case TERMINATE: {
                        return false;
                    }
                    case SKIP_SIBLINGS: {
                        return true;
                    }
                    case CONTINUE: {
                        if (!MoreFiles.walkDirSorted(file, comparator, visitor)) {
                            visitor.postVisitDirectory(file, null);
                            return false;
                        }
                    }
                    case SKIP_SUBTREE: {
                        if (FileVisitResult.TERMINATE != visitor.postVisitDirectory(file, null)) break;
                        return false;
                    }
                }
                continue;
            }
            switch (visitor.visitFile(file, attrs)) {
                case SKIP_SIBLINGS: {
                    return true;
                }
                case TERMINATE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static class PathWithAttributesIterator
    implements Iterator<PathWithAttributes> {
        private final Comparator<Path> comparator;
        private final Path path;
        private Deque<Iterator<PathWithAttributes>> iteratorStack;
        private PathWithAttributes next;

        PathWithAttributesIterator(Path path, Comparator<Path> comparator) {
            this.comparator = comparator;
            this.path = path;
        }

        @Override
        public boolean hasNext() {
            this.maybeReadNext();
            return this.next != null;
        }

        @Override
        public PathWithAttributes next() {
            this.maybeReadNext();
            if (this.next == null) {
                throw new NoSuchElementException("iterator is depleted!");
            }
            PathWithAttributes result = this.next;
            this.next = null;
            return result;
        }

        private void maybeReadNext() {
            if (this.next != null) {
                return;
            }
            if (this.iteratorStack == null) {
                this.iteratorStack = new LinkedList<Iterator<PathWithAttributes>>();
                try {
                    BasicFileAttributes attributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
                    this.next = new PathWithAttributes(this.path, attributes);
                    if (attributes.isDirectory()) {
                        this.iteratorStack.push(MoreFiles.listDirSorted(this.path, this.comparator).iterator());
                    }
                }
                catch (FileNotFoundException | NoSuchFileException attributes) {
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            while (this.next == null && !this.iteratorStack.isEmpty()) {
                Iterator<PathWithAttributes> it = this.iteratorStack.peek();
                if (it.hasNext()) {
                    this.next = it.next();
                    it.remove();
                } else {
                    this.iteratorStack.pop();
                }
                if (this.next == null || !this.next.getAttributes().isDirectory()) continue;
                try {
                    this.iteratorStack.push(MoreFiles.listDirSorted(this.next.getPath(), this.comparator).iterator());
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    this.next = null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

