/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.io;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public class PathWithAttributes {
    private final Path path;
    private volatile BasicFileAttributes attributes;

    public PathWithAttributes(@Nonnull Path path) {
        this(path, null);
    }

    public PathWithAttributes(@Nonnull Path path, @Nullable BasicFileAttributes attributes) {
        this.attributes = attributes;
        this.path = Objects.requireNonNull(path, "path");
    }

    @Nonnull
    public BasicFileAttributes getAttributes() {
        if (this.attributes == null) {
            try {
                this.attributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.attributes;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }
}

