/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.io;

import com.atlassian.bitbucket.mesh.io.SyncFileTreeCallback;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Objects;

public class SyncFileTreeParameters {
    private static final SyncFileTreeCallback DEFAULT_CALLBACK = new SyncFileTreeCallback(){

        @Override
        public void onConflict(@Nonnull Path source, @Nonnull BasicFileAttributes attrs, @Nonnull Path destination) {
        }
    };
    private final boolean allowHardLinks;
    private final SyncFileTreeCallback callback;
    private final Path destination;
    private final boolean detectMissing;
    private final Instant modifiedSince;
    private final boolean replaceExisting;
    private final Path source;

    private SyncFileTreeParameters(Builder builder) {
        this.allowHardLinks = builder.allowHardLinks;
        this.callback = (SyncFileTreeCallback)MoreObjects.firstNonNull((Object)builder.callback, (Object)DEFAULT_CALLBACK);
        this.destination = builder.destination;
        this.detectMissing = builder.detectMissing;
        this.modifiedSince = builder.modifiedSince;
        this.replaceExisting = builder.replaceExisting;
        this.source = builder.source;
    }

    @Nonnull
    public SyncFileTreeCallback getCallback() {
        return this.callback;
    }

    @Nonnull
    public Path getDestination() {
        return this.destination;
    }

    @Nullable
    public Instant getModifiedSince() {
        return this.modifiedSince;
    }

    @Nonnull
    public Path getSource() {
        return this.source;
    }

    public boolean isAllowHardLinks() {
        return this.allowHardLinks;
    }

    public boolean isDetectMissing() {
        return this.detectMissing;
    }

    public boolean isReplaceExisting() {
        return this.replaceExisting;
    }

    public static class Builder {
        private final Path destination;
        private final Path source;
        private boolean allowHardLinks;
        private SyncFileTreeCallback callback;
        private boolean detectMissing;
        private Instant modifiedSince;
        private boolean replaceExisting;

        public Builder(@Nonnull Path source, @Nonnull Path destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.source = Objects.requireNonNull(source, "source");
            this.allowHardLinks = true;
        }

        @Nonnull
        public SyncFileTreeParameters build() {
            return new SyncFileTreeParameters(this);
        }

        @Nonnull
        public Builder allowHardLinks(boolean value) {
            this.allowHardLinks = value;
            return this;
        }

        @Nonnull
        public Builder callback(@Nullable SyncFileTreeCallback value) {
            this.callback = value;
            return this;
        }

        @Nonnull
        public Builder detectMissing(boolean value) {
            this.detectMissing = value;
            return this;
        }

        @Nonnull
        public Builder modifiedSince(@Nullable Instant value) {
            this.modifiedSince = value;
            return this;
        }

        @Nonnull
        public Builder replaceExisting(boolean value) {
            this.replaceExisting = value;
            return this;
        }
    }
}

