/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.io;

import com.atlassian.bitbucket.mesh.io.IoBiConsumer;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.WillNotClose;
import org.apache.commons.lang3.StringUtils;

public class UnderLock {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final Path file;
    private final Duration timeout;

    private UnderLock(@Nonnull Path file, @Nonnull Duration timeout) {
        this.file = file;
        this.timeout = timeout;
    }

    @Nonnull
    public static UnderLock forFile(@Nonnull Path file) {
        return new UnderLock(file, Duration.ZERO);
    }

    @Nonnull
    public static UnderLock forFile(@Nonnull Path file, @Nonnull Duration timeout) {
        return new UnderLock(Objects.requireNonNull(file, "file"), Objects.requireNonNull(timeout, "timeout"));
    }

    public void edit(@Nonnull IoBiConsumer<? super BufferedReader, ? super Writer> mutator, boolean withBackup) throws IOException, OverlappingFileLockException {
        try (LockedFile locked = this.acquireLock(true);){
            locked.edit(mutator, withBackup);
        }
    }

    public void editRaw(@Nonnull IoBiConsumer<? super InputStream, ? super OutputStream> mutator, boolean withBackup) throws IOException {
        Objects.requireNonNull(mutator, "mutator");
        try (LockedFile locked = this.acquireLock(true);){
            locked.editRaw(mutator, withBackup);
        }
    }

    @Nonnull
    public LockedFile lock() throws IOException, OverlappingFileLockException {
        return this.acquireLock(true);
    }

    public void lockIndefinitely(@Nullable String content) throws IOException, OverlappingFileLockException {
        try (LockedFile locked = this.acquireLock(false);){
            if (StringUtils.isNotBlank((CharSequence)content)) {
                locked.edit((ignored, writer) -> writer.write(content), false);
                locked.rollBack();
            }
        }
    }

    public void releaseIfNotHeld() throws IOException {
        this.releaseIfNotHeld(null);
    }

    public void releaseIfNotHeld(@Nullable Runnable cleanupTask) throws IOException {
        Path lockFile = this.getLockFile();
        try (FileChannel lockChannel = FileChannel.open(lockFile, StandardOpenOption.WRITE);
             FileLock lock = lockChannel.tryLock();){
            if (lock == null) {
                throw new OverlappingFileLockException();
            }
            if (cleanupTask != null) {
                cleanupTask.run();
            }
            Files.delete(lockFile);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    public void write(@Nonnull @WillNotClose ReadableByteChannel source) throws IOException {
        try (LockedFile locked = this.acquireLock(true);){
            locked.write(source);
        }
    }

    private static InputStream newInputStream(Path file) throws IOException {
        try {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return null;
        }
    }

    private static BufferedReader newReader(Path file) throws IOException {
        try {
            return Files.newBufferedReader(file, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return null;
        }
    }

    private static FileChannel openLockWithHardLink(Path lockFile) throws IOException {
        long n = RANDOM.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        Path temporaryLockFile = lockFile.resolveSibling("tmp-" + Long.toString(n, 16) + "-" + String.valueOf(lockFile.getFileName()));
        FileChannel lockChannel = FileChannel.open(temporaryLockFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        Exception caughtException = null;
        try {
            Files.createLink(lockFile, temporaryLockFile);
        }
        catch (FileAlreadyExistsException e) {
            caughtException = e;
            throw e;
        }
        catch (IOException | UnsupportedOperationException e) {
            try {
                FileChannel fileChannel = FileChannel.open(lockFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                return fileChannel;
            }
            catch (IOException suppressed) {
                e.addSuppressed(suppressed);
                caughtException = e;
                throw e;
            }
        }
        finally {
            if (caughtException != null) {
                try {
                    lockChannel.close();
                }
                catch (IOException suppressed) {
                    caughtException.addSuppressed(suppressed);
                }
            }
            try {
                Files.deleteIfExists(temporaryLockFile);
            }
            catch (IOException suppressed) {
                if (caughtException == null) {
                    throw suppressed;
                }
                caughtException.addSuppressed(suppressed);
            }
        }
        return lockChannel;
    }

    private LockedFile acquireLock(boolean deleteOnClose) throws IOException {
        Path lockFile = this.getLockFile();
        AbstractInterruptibleChannel lockChannel = null;
        FileLock lock = null;
        try {
            long deadline = System.nanoTime() + this.timeout.toNanos();
            long sleepNanos = 100000L;
            while (lock == null) {
                block10: {
                    try {
                        lockChannel = UnderLock.openLockWithHardLink(lockFile);
                        lock = ((FileChannel)lockChannel).tryLock(0L, Long.MAX_VALUE, false);
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                    }
                    catch (FileAlreadyExistsException e) {
                        if (e.getFile().equals(lockFile.toString())) break block10;
                        throw e;
                    }
                }
                if (lock != null) continue;
                long curTime = System.nanoTime();
                if (curTime > deadline) {
                    throw new OverlappingFileLockException();
                }
                LockSupport.parkNanos(Math.min(deadline - curTime, sleepNanos));
                sleepNanos = Math.min(50000000L, sleepNanos * 2L);
            }
            return new DefaultLockedFile((FileChannel)lockChannel, lock, lockFile, deleteOnClose);
        }
        catch (IOException | RuntimeException exception) {
            try {
                if (lockChannel != null) {
                    lockChannel.close();
                }
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
    }

    private Path getLockFile() {
        return this.file.resolveSibling(String.valueOf(this.file.getFileName()) + ".lock");
    }

    public static interface LockedFile
    extends AutoCloseable {
        @Override
        public void close() throws IOException;

        public void edit(@Nonnull IoBiConsumer<? super BufferedReader, ? super Writer> var1, boolean var2) throws IOException;

        public void editRaw(@Nonnull IoBiConsumer<? super InputStream, ? super OutputStream> var1, boolean var2) throws IOException;

        public void rollBack();

        public void write(@Nonnull @WillNotClose ReadableByteChannel var1) throws IOException;
    }

    private class DefaultLockedFile
    implements LockedFile {
        private final boolean deleteOnClose;
        private final FileLock lock;
        private final FileChannel lockChannel;
        private final Path lockFile;
        private volatile boolean closed;
        private volatile boolean staged;
        private volatile boolean withBackup;

        private DefaultLockedFile(FileChannel lockChannel, FileLock lock, Path lockFile, boolean deleteOnClose) {
            this.deleteOnClose = deleteOnClose;
            this.lockChannel = lockChannel;
            this.lock = lock;
            this.lockFile = lockFile;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            Exception exception = null;
            if (this.staged) {
                try {
                    if (this.withBackup) {
                        Files.move(UnderLock.this.file, UnderLock.this.file.resolveSibling(String.valueOf(UnderLock.this.file.getFileName()) + ".bak"), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.deleteIfExists(UnderLock.this.file);
                    }
                    Files.move(this.lockFile, UnderLock.this.file, new CopyOption[0]);
                }
                catch (IOException | RuntimeException e) {
                    exception = e;
                }
            }
            try {
                this.lock.close();
            }
            catch (IOException | RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            try {
                this.lockChannel.close();
            }
            catch (IOException | RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            if (this.deleteOnClose) {
                try {
                    Files.deleteIfExists(this.lockFile);
                }
                catch (IOException | RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                Throwables.propagateIfPossible((Throwable)exception, IOException.class);
            }
            this.closed = true;
        }

        @Override
        public void edit(@Nonnull IoBiConsumer<? super BufferedReader, ? super Writer> mutator, boolean withBackup) throws IOException {
            this.checkLockHeld();
            Writer lockWriter = Channels.newWriter(this.lockChannel, StandardCharsets.UTF_8.newEncoder(), 8192);
            try (BufferedReader reader = UnderLock.newReader(UnderLock.this.file);){
                this.withBackup = withBackup && reader != null;
                mutator.accept(reader, lockWriter);
                this.staged = true;
            }
            lockWriter.flush();
        }

        @Override
        public void editRaw(@Nonnull IoBiConsumer<? super InputStream, ? super OutputStream> mutator, boolean withBackup) throws IOException {
            this.checkLockHeld();
            OutputStream lockOutput = Channels.newOutputStream(this.lockChannel);
            try (InputStream inputStream = UnderLock.newInputStream(UnderLock.this.file);){
                this.withBackup = withBackup && inputStream != null;
                mutator.accept(inputStream, lockOutput);
                this.staged = true;
            }
            lockOutput.flush();
        }

        @Override
        public void rollBack() {
            this.checkLockHeld();
            this.staged = false;
        }

        @Override
        public void write(@Nonnull @WillNotClose ReadableByteChannel source) throws IOException {
            this.checkLockHeld();
            this.lockChannel.transferFrom(source, 0L, Long.MAX_VALUE);
            this.staged = true;
        }

        private void checkLockHeld() {
            if (this.closed) {
                throw new IllegalStateException("Lock on " + String.valueOf(UnderLock.this.file) + " has already been released");
            }
        }
    }
}

