/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.nutcluster;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.nutcluster.NutclusterMappedLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.annotation.Nonnull;

class NutclusterClusterLock
implements ClusterLock {
    private final NutclusterMappedLock lockMap;
    private final String lockName;

    public NutclusterClusterLock(NutclusterMappedLock lockMap, String lockName) {
        if (lockName == null || lockName.trim().isEmpty()) {
            throw new IllegalArgumentException("lockName cannot be empty: " + lockName);
        }
        this.lockMap = lockMap;
        this.lockName = lockName;
    }

    public boolean isHeldByCurrentThread() {
        return this.lockMap.isHeldByCurrentThread(this.lockName);
    }

    public void lock() {
        this.lockMap.lock(this.lockName);
    }

    public void lockInterruptibly() throws InterruptedException {
        this.lockMap.lockInterruptibly(this.lockName);
    }

    public boolean tryLock() {
        return this.lockMap.tryLock(this.lockName);
    }

    public boolean tryLock(long time, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.lockMap.tryLock(this.lockName, time, unit);
    }

    public void unlock() {
        this.lockMap.unlock(this.lockName);
    }

    @Nonnull
    public Condition newCondition() {
        throw new UnsupportedOperationException("newCondition() not supported in ClusterLock");
    }
}

