/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.plugin;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.core.plugin.AbstractAppLinksTypeModuleDescriptor;
import com.atlassian.applinks.spi.manifest.ManifestProducer;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;

public class ApplicationTypeModuleDescriptor
extends AbstractAppLinksTypeModuleDescriptor<ApplicationType> {
    private static final String XML_MANIFEST_PRODUCER = "manifest-producer";
    private Class<ManifestProducer> manifestProducerClass = null;
    private String manifestProducerClassName;

    public ApplicationTypeModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    protected void validate(Element element) {
        super.validate(element);
        Element manifestProducer = element.element(XML_MANIFEST_PRODUCER);
        if (manifestProducer == null) {
            throw new ValidationException("ApplicationTypeModuleDescriptor validation errors", Collections.singletonList(String.format("missing %s tag", XML_MANIFEST_PRODUCER)));
        }
        if (manifestProducer.attributeValue("class") == null) {
            throw new ValidationException("ApplicationTypeModuleDescriptor validation errors", Collections.singletonList(String.format("missing %s attribute in %s tag", "class", XML_MANIFEST_PRODUCER)));
        }
    }

    public void enabled() {
        super.enabled();
        try {
            this.manifestProducerClass = this.plugin.loadClass(this.manifestProducerClassName, this.getModuleClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Unable to load this application type's " + ManifestProducer.class.getSimpleName() + " class.", cnfe);
        }
    }

    public void disabled() {
        this.manifestProducerClass = null;
        super.disabled();
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        Objects.requireNonNull(plugin, "plugin can't be null");
        Objects.requireNonNull(element, "element can't be null");
        super.init(plugin, element);
        this.manifestProducerClassName = element.element(XML_MANIFEST_PRODUCER).attributeValue("class");
    }

    protected Class<ManifestProducer> getManifestProducerClass() {
        return this.manifestProducerClass;
    }

    public ManifestProducer getManifestProducer() {
        return (ManifestProducer)((ContainerManagedPlugin)this.plugin).getContainerAccessor().createBean(this.manifestProducerClass);
    }
}

