/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest;

import com.atlassian.applinks.core.auth.OrphanedTrustCertificate;
import com.atlassian.applinks.core.auth.OrphanedTrustDetector;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.model.OrphanedTrustEntityList;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="orphaned-trust")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@WebSudoRequired
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@AdminApplicationLinksFilterBinding
@AdminOnly
public class OrphanedTrustResource {
    private final OrphanedTrustDetector orphanedTrustDetector;

    @Inject
    public OrphanedTrustResource(@Qualifier(value="delegatingOrphanedTrustDetector") OrphanedTrustDetector orphanedTrustDetector) {
        this.orphanedTrustDetector = orphanedTrustDetector;
    }

    @GET
    public Response getIds() {
        return Response.ok((Object)new OrphanedTrustEntityList(this.orphanedTrustDetector.findOrphanedTrustCertificates())).build();
    }

    @DELETE
    @Path(value="{type}/{id}")
    public Response delete(@PathParam(value="type") String typeStr, @PathParam(value="id") String id) {
        OrphanedTrustCertificate.Type type;
        try {
            type = OrphanedTrustCertificate.Type.valueOf(typeStr);
        }
        catch (IllegalArgumentException e) {
            return RestUtil.badRequest("Invalid type parameter: " + typeStr);
        }
        this.orphanedTrustDetector.deleteTrustCertificate(id, type);
        return RestUtil.ok("Deleted certificate with id: " + id);
    }
}

