/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.concurrent.ConcurrentExecutor;
import com.atlassian.applinks.core.rest.AbstractResource;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.context.CurrentContext;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.model.ApplicationLinkState;
import com.atlassian.applinks.core.rest.model.ApplicationLinkStateEntity;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ApplicationStatus;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.RequestFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="listApplicationlinkstates")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@AdminApplicationLinksFilterBinding
@AdminOnly
public class ApplicationLinkStatesUIResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationLinkStatesUIResource.class);
    private final MutatingApplicationLinkService applicationLinkService;
    private final ManifestRetriever manifestRetriever;
    private final I18nResolver i18nResolver;
    private final ConcurrentExecutor executor;

    @Inject
    public ApplicationLinkStatesUIResource(MutatingApplicationLinkService applicationLinkService, ManifestRetriever manifestRetriever, I18nResolver i18nResolver, RestUrlBuilder restUrlBuilder, RequestFactory requestFactory, InternalTypeAccessor typeAccessor, ConcurrentExecutor executor) {
        super(restUrlBuilder, typeAccessor, requestFactory, applicationLinkService);
        this.applicationLinkService = applicationLinkService;
        this.manifestRetriever = manifestRetriever;
        this.i18nResolver = i18nResolver;
        this.executor = executor;
    }

    @GET
    @Path(value="id/{id}")
    public Response getApplicationLinkState(@PathParam(value="id") ApplicationId id) {
        try {
            final MutableApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(id);
            if (applicationLink == null) {
                throw new Exception("Couldn't find application link");
            }
            Future<ApplicationLinkState> applicationLinkStateFuture = this.executor.submit(new CurrentContextAwareCallable<ApplicationLinkState>(){

                @Override
                public ApplicationLinkState callWithContext() throws Exception {
                    if (ApplicationLinkStatesUIResource.this.manifestRetriever.getApplicationStatus(applicationLink.getRpcUrl(), applicationLink.getType()) == ApplicationStatus.UNAVAILABLE) {
                        return ApplicationLinkState.OFFLINE;
                    }
                    try {
                        Manifest manifest = ApplicationLinkStatesUIResource.this.manifestRetriever.getManifest(applicationLink.getRpcUrl(), applicationLink.getType());
                        if (!applicationLink.getId().equals((Object)manifest.getId())) {
                            if (manifest.getAppLinksVersion() != null && manifest.getAppLinksVersion().getMajor() >= 3) {
                                return ApplicationLinkState.UPGRADED_TO_UAL;
                            }
                            return ApplicationLinkState.UPGRADED;
                        }
                    }
                    catch (ManifestNotFoundException e) {
                        LOG.error("The {} application type failed to produce a Manifest for Application Link {}, so we cannot determine the link status.", (Object)TypeId.getTypeId((ApplicationType)applicationLink.getType()).toString(), (Object)applicationLink.getId().toString());
                    }
                    return ApplicationLinkState.OK;
                }
            });
            return RestUtil.ok(new ApplicationLinkStateEntity(applicationLinkStateFuture.get()));
        }
        catch (Exception e) {
            LOG.error("Error occurred when retrieving application link state", (Throwable)e);
            return RestUtil.serverError(this.i18nResolver.getText("applinks.error.retrieving.application.link.list", new Serializable[]{e.getMessage()}));
        }
    }

    private static abstract class CurrentContextAwareCallable<T>
    implements Callable<T> {
        private final UriInfo uriInfo = CurrentContext.getUriInfo();
        private final HttpServletRequest httpServletRequest = CurrentContext.getHttpServletRequest();

        private CurrentContextAwareCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() throws Exception {
            UriInfo oldUriInfoContext = CurrentContext.getUriInfo();
            HttpServletRequest oldRequest = CurrentContext.getHttpServletRequest();
            CurrentContext.setUriInfo(this.uriInfo);
            CurrentContext.setHttpServletRequest(this.httpServletRequest);
            try {
                T t = this.callWithContext();
                return t;
            }
            finally {
                CurrentContext.setUriInfo(oldUriInfoContext);
                CurrentContext.setHttpServletRequest(oldRequest);
            }
        }

        public abstract T callWithContext() throws Exception;
    }
}

