/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.core.manifest.AppLinksManifestDownloader;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;

@Path(value="authenticationinfo")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@AdminApplicationLinksFilterBinding
@AdminOnly
public class AuthenticationResource {
    private final AppLinksManifestDownloader downloader;

    @Inject
    public AuthenticationResource(AppLinksManifestDownloader downloader) {
        this.downloader = downloader;
    }

    @GET
    public Response getIsAdminUser() {
        return RestUtil.ok();
    }

    @GET
    @Path(value="id/{applinkId}/url/{url:.*$}")
    public Response rpcUrlIsReachable(@PathParam(value="applinkId") String applicationId, @PathParam(value="url") URI uri, @QueryParam(value="url") URI qUrl) {
        if (qUrl != null) {
            uri = qUrl;
        }
        try {
            Manifest manifest = this.downloader.download(uri);
            if (manifest.getId().equals((Object)new ApplicationId(applicationId))) {
                return RestUtil.ok();
            }
            return RestUtil.notFound("");
        }
        catch (ManifestNotFoundException e) {
            return RestUtil.notFound("");
        }
    }
}

