/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.ui;

import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.rest.AbstractResource;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.model.LinkAndAuthProviderEntity;
import com.atlassian.applinks.core.rest.model.ListEntity;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.helper.AppLinkResourceHelper;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.RequestFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="listApplicationlinks")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@AdminApplicationLinksFilterBinding
@AdminOnly
public class ListApplicationLinksUIResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(ListApplicationLinksUIResource.class);
    private final I18nResolver i18nResolver;
    private final AppLinkResourceHelper appLinkResourceHelper;

    @Inject
    public ListApplicationLinksUIResource(MutatingApplicationLinkService applicationLinkService, I18nResolver i18nResolver, RestUrlBuilder restUrlBuilder, RequestFactory requestFactory, InternalTypeAccessor typeAccessor, AppLinkResourceHelper appLinkResourceHelper) {
        super(restUrlBuilder, typeAccessor, requestFactory, applicationLinkService);
        this.i18nResolver = i18nResolver;
        this.appLinkResourceHelper = appLinkResourceHelper;
    }

    @GET
    public Response getApplicationLinks() {
        List<LinkAndAuthProviderEntity> links;
        try {
            links = this.appLinkResourceHelper.retrieveLinkAndAuthProviderEntityList(this.applicationLinkService.getApplicationLinks());
        }
        catch (Exception e) {
            LOG.error("Error occurred when retrieving list of application links", (Throwable)e);
            return RestUtil.serverError(this.i18nResolver.getText("applinks.error.retrieving.application.link.list", new Serializable[]{e.getMessage()}));
        }
        links.sort((e1, e2) -> {
            int compareByType = e1.getApplication().getTypeId().get().compareTo(e2.getApplication().getTypeId().get());
            if (compareByType != 0) {
                return compareByType;
            }
            return e1.getApplication().getName().compareTo(e2.getApplication().getName());
        });
        return RestUtil.ok(new ListEntity<LinkAndAuthProviderEntity>(links));
    }
}

