/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.manifest.AppLinksManifestDownloader;
import com.atlassian.applinks.core.rest.AbstractResource;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.core.util.RequestUtil;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ApplicationStatus;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="relocateApplicationlink")
@Api
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@AdminApplicationLinksFilterBinding
@AdminOnly
public class RelocateApplicationLinkUIResource
extends AbstractResource {
    private static final String APPLINKS_ALLOW_ALL_HOSTS = "applinks.allow.all.hosts";
    private static final String DEV_MODE_ENABLED = "atlassian.dev.mode";
    private static final Logger LOG = LoggerFactory.getLogger(RelocateApplicationLinkUIResource.class);
    private final MutatingApplicationLinkService applicationLinkService;
    private final ManifestRetriever manifestRetriever;
    private final AppLinksManifestDownloader manifestDownloader;
    private final I18nResolver i18nResolver;
    private final UserManager userManager;

    @Inject
    public RelocateApplicationLinkUIResource(RestUrlBuilder restUrlBuilder, MutatingApplicationLinkService applicationLinkService, I18nResolver i18nResolver, ManifestRetriever manifestRetriever, AppLinksManifestDownloader manifestDownloader, InternalTypeAccessor internalTypeAccessor, RequestFactory requestFactory, UserManager userManager) {
        super(restUrlBuilder, internalTypeAccessor, requestFactory, applicationLinkService);
        this.applicationLinkService = applicationLinkService;
        this.i18nResolver = i18nResolver;
        this.manifestRetriever = manifestRetriever;
        this.manifestDownloader = manifestDownloader;
        this.userManager = userManager;
    }

    @POST
    @ApiOperation(value="Update the RPC URL of the remote application", authorizations={@Authorization(value="SysAdmin")})
    @ApiResponses(value={@ApiResponse(code=204, message="Updated successfully (this is the only mutating operation)"), @ApiResponse(code=400, message="The application running at the new URL has a different application type than the existing applink"), @ApiResponse(code=404, message="The specified server ID doesn't have an application link on this server"), @ApiResponse(code=409, message="The server located at the specified URL is not responding, resubmit with \"?nowarning=true\" to force the update (display URL will be set to RPC URL)")})
    @Path(value="{applinkId}")
    public Response relocate(@PathParam(value="applinkId") String applicationId, @QueryParam(value="newUrl") String urlString, @QueryParam(value="nowarning") boolean nowarning) throws TypeNotInstalledException {
        URI url;
        MutableApplicationLink link;
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return RestUtil.forbidden(this.i18nResolver.getText("applinks.error.only.sysadmin.operation"));
        }
        if (!Boolean.getBoolean(APPLINKS_ALLOW_ALL_HOSTS) && !Boolean.getBoolean(DEV_MODE_ENABLED)) {
            RequestUtil.validateUriAgainstBlocklist(urlString, this.i18nResolver);
        }
        if (!StringUtils.isBlank((CharSequence)(link = this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId))).getClientId())) {
            return Response.status((int)405).build();
        }
        try {
            url = URIUtil.uncheckedToUri(urlString);
        }
        catch (RuntimeException e) {
            return RestUtil.serverError(e.getMessage());
        }
        if (link == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{applicationId}));
        }
        if (this.manifestRetriever.getApplicationStatus(url, link.getType()) == ApplicationStatus.UNAVAILABLE) {
            if (nowarning) {
                return this.update(link, url, url);
            }
            return Response.status((int)409).build();
        }
        URI displayUrl = url;
        try {
            Manifest manifest = this.manifestDownloader.download(url);
            if (!this.typeAccessor.loadApplicationType(manifest.getTypeId()).equals((Object)link.getType())) {
                return Response.status((int)400).entity((Object)this.i18nResolver.getText("applinks.error.relocate.type", new Serializable[]{urlString, this.i18nResolver.getText(this.typeAccessor.loadApplicationType(manifest.getTypeId()).getI18nKey()), this.i18nResolver.getText(link.getType().getI18nKey())})).build();
            }
            displayUrl = manifest.getUrl();
        }
        catch (ManifestNotFoundException manifestNotFoundException) {
            // empty catch block
        }
        return this.update(link, url, displayUrl);
    }

    private Response update(MutableApplicationLink link, URI rpcUrl, URI displayUrl) {
        link.update(ApplicationLinkDetails.builder((ApplicationLink)link).rpcUrl(rpcUrl).displayUrl(displayUrl).build());
        LOG.info("Changed RPC URL from {} to {} and display URL from {} to {} for ApplicationLink {} .", new Object[]{link.getRpcUrl(), rpcUrl, link.getDisplayUrl(), displayUrl, link.getId()});
        return RestUtil.noContent();
    }
}

