/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.util;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class AvailableScopesResolverHelper {
    private static final String JSM_KB_SCOPE = "JSM_KB";
    private static final String JSM_KB_SCOPE_FEATURE_KEY = "scope.jsm.kb";
    private static final Map<String, String> SCOPE_FEATURE_KEY_TO_SCOPE_VALUE_MAP = ImmutableMap.of((Object)"scope.jsm.kb", (Object)"JSM_KB");
    private final DarkFeatureManager darkFeatureManager;

    @Autowired
    public AvailableScopesResolverHelper(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public List<String> getFilteredAvailableScopes(List<String> availableScopes) {
        Set<String> scopesToBeRemoved = this.getScopesToBeRemoved();
        return availableScopes.stream().filter(scope -> !scopesToBeRemoved.contains(scope)).toList();
    }

    private Set<String> getScopesToBeRemoved() {
        return SCOPE_FEATURE_KEY_TO_SCOPE_VALUE_MAP.entrySet().stream().filter(entry -> !this.isDarkFeatureEnabledForAllUsers((String)entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toUnmodifiableSet());
    }

    private boolean isDarkFeatureEnabledForAllUsers(String darkFeatureKey) {
        Objects.requireNonNull(darkFeatureKey, "Dark feature key cannot be null");
        return this.darkFeatureManager.isEnabledForAllUsers(darkFeatureKey).orElse(Boolean.FALSE);
    }
}

