/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.net;

import com.atlassian.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;

public final class ResponseHeaderUtil {
    @VisibleForTesting
    static final String HEADER_XFRAME_OPTIONS = "X-Frame-Options";
    @VisibleForTesting
    static final String HEADER_CONTENT_SECURITY_POLICY = "Content-Security-Policy";

    private ResponseHeaderUtil() {
    }

    public static void preventCrossFrameClickJacking(@Nonnull HttpServletResponse response) {
        Objects.requireNonNull(response, "response");
        response.setHeader(HEADER_XFRAME_OPTIONS, "SAMEORIGIN");
        response.setHeader(HEADER_CONTENT_SECURITY_POLICY, "frame-ancestors 'self'");
    }
}

