/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.rest.interceptor;

import com.atlassian.applinks.internal.common.rest.util.RestResponses;
import com.atlassian.applinks.internal.rest.model.IllegalRestRepresentationStateException;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class RestRepresentationStateExceptionMapper
implements ExceptionMapper<IllegalRestRepresentationStateException> {
    private static final Logger log = LoggerFactory.getLogger(RestRepresentationStateExceptionMapper.class);
    private final I18nResolver i18nResolver;

    @Inject
    public RestRepresentationStateExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(IllegalRestRepresentationStateException exception) {
        return this.createResponse(exception);
    }

    private Response createResponse(IllegalRestRepresentationStateException e) {
        log.warn("Converting REST representation into a domain object failed with IllegalRestRepresentationStateException: {}:{}", (Object)e.getContext(), (Object)e.getMessage());
        log.debug("Stack trace for IllegalRestRepresentationStateException with context {}", (Object)e.getContext(), (Object)e);
        return RestResponses.badRequest(e.getContext(), this.i18nResolver.getText("applinks.rest.invalidrepresentation", new Serializable[]{e.getContext()}));
    }
}

